#pragma once
#include <windows.h>

#include "json.hpp"

using json = nlohmann::json;

using namespace std;

#ifdef __cplusplus    // If used by C++ code, 
extern "C" {          // we need to export the C interface
#endif

	bool ReadAnyValueFromRegistry(LPCTSTR psDirectory, LPCTSTR psName, LPBYTE lpData, LPDWORD lpType, LPDWORD lpcbData);
	BOOL ReadModelNameFromRegistry(WCHAR* sMtName, int nLen);
	BOOL ReadSystemConfigurationNameFromRegistry(WCHAR* sMtName, int nLen);
	BOOL ReadSerialFromRegistry(WCHAR* sMtName, int nLen);
	BOOL SetSystemConfigurationNameToRegistry(WCHAR* sMtName, int nLen);
	BOOL SetSerialNumberToRegistry(WCHAR* serialNumber, int nLen);
	bool SetRegistryValue(LPCTSTR psDirectory, LPCTSTR psName, LPBYTE lpData, DWORD lpType, DWORD lpcbData);
	void CharToWChar(char* modelName, wchar_t*& wc);

	void GetWmiValue(char* server, char* query, char* property, bool isArray, vector<string>& value);
	json ReadJson(string filename);
	void GetModelInfo(char* modelName, char* serialNumber);
	int GetIntJson(char* key, string filename);


#ifdef __cplusplus    // If used by C++ code, 
}
#endif