/**
 * @file mcm-modem-info.h
 *
 * This library is for Moxa Connection Management
 *
 * @author York LY Chang <YorkLY.Chang@moxa.com>
 */

#ifndef _MCM_MODEM_INFO_H_
#define _MCM_MODEM_INFO_H_
#include "mcm-base-info.h"

/**
 * McmModemState:
 *
 * Enumeration of possible connection states.
 */
typedef enum {
    MCM_MODEM_STATE_NOT_READY    = 0, /**< The modem can't be detected or not inserted, or something undefined by MCM. */
    MCM_MODEM_STATE_INITIALIZING = 1, /**< The modem is currently being initialized. */
    MCM_MODEM_STATE_PIN_LOCKED   = 2, /**< The modem needs to be unlocked SIM_PIN1. */
    MCM_MODEM_STATE_PUK_LOCKED   = 3, /**< The modem needs to be unlocked SIM_PUK1. */
    MCM_MODEM_STATE_RADIO_OFF    = 4, /**< The modem radio power is off but sim power may not off. */
    MCM_MODEM_STATE_RADIO_ON     = 5, /**< The modem radio power is on but idle and not registered, not searching */
    MCM_MODEM_STATE_SEARCHING    = 6, /**< The modem radio power is on and under searching */
    MCM_MODEM_STATE_REGISTERED   = 7, /**< The modem is registered with a network provider but without data connections.*/
    MCM_MODEM_STATE_CONNECTING   = 8, /**< The modem is establishing the PDN session. */
    MCM_MODEM_STATE_CONNECTED    = 9, /**< One or more packet data bearers is active and connected. */
    MCM_MODEM_STATE_NO_SIM       = 99 /**< SIM missing or unavailable */
} McmModemState;

/**
 * @brief A help function for get all ethernet properties.
 *
 * @param interfaceName (input) Interface name.
 *
 * @param arr_len (output) Number of properties array.
 *
 * @param info_arr (output) Properties array.
 *
 * @return If get ethernet properties success return 0. If fail, return error number.
 */
int mcm_modem_get_all_properties(char *interfaceName, int *arr_len, mcm_property_info **info_arr);

/**
 * @brief A help function for get property.
 *
 * @param interfaceName (input) Interface name.
 *
 * @param propertyName (input) Property name.
 *
 * @param cached (input) Using caeched property value.
 *
 * @param propertyValue (output) Property value.
 *
 * @return If get modem property success return 0. If fail, return error number.
 *
 */
int mcm_modem_get_property(char *interfaceName, char *propertyName, char **propertyValue, int cached);

/**
 * @brief A help function for get modem information.
 *
 * @param interfaceName (input) Interface name.
 *
 * @param modem_info (output) A modem infomation structure.
 *
 * @return If get modem properties success return 0. If fail, return error number.
 */
int mcm_get_modem_info(char *interfaceName, mcm_modem_info *modem_info);

#endif
