#!/bin/bash
#
# Copyright (C) 2024 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#
# Authors:
#       2024  Henry LC Chen  <henrylc.chen@moxa.com>

source "${INSTL_SCRIPT_DIR}/lib/util.sh"
source "${INSTL_SCRIPT_DIR}/lib/logger.sh"
source "${INSTL_SCRIPT_DIR}/lib/driver.sh"
log::init "${INSTL_LOG_FILE}" "${INSTL_LOG_LEVEL}"

set -e

DRIVER_NAME="i915"

main() {
        if util::is_exists "$(/usr/sbin/modinfo -n ${DRIVER_NAME} 2>/dev/null)" >/dev/null 2>&1; then
                /usr/sbin/modinfo "${DRIVER_NAME}" >>"${INSTL_LOG_FILE}" 2>&1

                if drv::is_loaded "${DRIVER_NAME}"; then
                        log::info "$(printf " %-50s$(colors::green %-15s)$(colors::green %-25s)\n" "- ${DRIVER_NAME}" "Yes" "Loaded")"
                else
                        log::info "$(printf " %-50s$(colors::green %-15s)$(colors::red %-25s)\n" "- ${DRIVER_NAME}" "Yes" "Unloaded")"
                fi
        else
                log::info "$(printf " %-50s$(colors::red %-15s)%-25s\n" "- ${DRIVER_NAME}" "No" "N/A")"
        fi
}

main "$@"
