#!/bin/bash
#
# Copyright (C) 2023 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#
# Authors:
#       2023  Wilson YS Huang  <wilsonys.huang@moxa.com>

source "${INSTL_SCRIPT_DIR}/lib/util.sh"
source "${INSTL_SCRIPT_DIR}/lib/logger.sh"
log::init "${INSTL_LOG_FILE}" "${INSTL_LOG_LEVEL}"

set -e

main() {
        if [[ "${CFG_CONTROL_TOOLS[*]}" =~ "uart" ]]; then
                local serial_num

                if util::is_exists "/usr/sbin/mx-uart-ctl"; then
                        serial_num=$(find /dev/ttyM* 2>/dev/null | wc -l)

                        log::info "$(printf " %-50s$(colors::green %-15s)$(colors::green %-25s)\n" "- mx-uart-ctl" "Yes" "${serial_num} ports")"
                else
                        log::info "$(printf " %-50s$(colors::red %-15s)%-25s\n" "- mx-uart-ctl" "No" "N/A")"
                fi
        fi

        if [[ "${CFG_CONTROL_TOOLS[*]}" =~ "dio" ]]; then
                if util::is_exists "/usr/sbin/mx-dio-ctl"; then
                        local n_di=0
                        local n_do=0

                        while true; do
                                if /usr/sbin/mx-dio-ctl -i $n_di >/dev/null 2>&1; then
                                        ((n_di += 1))
                                else
                                        break
                                fi
                        done

                        while true; do
                                if /usr/sbin/mx-dio-ctl -o $n_do >/dev/null 2>&1; then
                                        ((n_do += 1))
                                else
                                        break
                                fi
                        done

                        log::info "$(printf " %-50s$(colors::green %-15s)$(colors::green %-25s)\n" "- mx-dio-ctl" "Yes" "${n_di} DI / ${n_do} DO")"
                else
                        log::info "$(printf " %-50s$(colors::red %-15s)%-25s\n" "- mx-dio-ctl" "No" "N/A")"
                fi
        fi

        if [[ "${CFG_CONTROL_TOOLS[*]}" =~ "led" ]]; then
                if util::is_exists "/usr/sbin/mx-led-ctl"; then
                        local n_idx=0

                        while true; do
                                if /usr/sbin/mx-led-ctl -i $n_idx >/dev/null 2>&1; then
                                        ((n_idx += 1))
                                else
                                        break
                                fi
                        done

                        log::info "$(printf " %-50s$(colors::green %-15s)$(colors::green %-25s)\n" "- mx-led-ctl" "Yes" "${n_idx} LEDs")"
                else
                        log::info "$(printf " %-50s$(colors::red %-15s)%-25s\n" "- mx-led-ctl" "No" "N/A")"
                fi
        fi

        if [[ "${CFG_CONTROL_TOOLS[*]}" =~ "relay" ]]; then
                if util::is_exists "/usr/sbin/mx-relay-ctl"; then
                        log::info "$(printf " %-50s$(colors::green %-15s)%-25s\n" "- mx-relay-ctl" "Yes" "N/A")"
                else
                        log::info "$(printf " %-50s$(colors::red %-15s)%-25s\n" "- mx-relay-ctl" "No" "N/A")"
                fi
        fi

        if [[ "${CFG_CONTROL_TOOLS[*]}" =~ "module" ]]; then
                if util::is_exists "/usr/sbin/mx-module-ctl"; then
                        log::info "$(printf " %-50s$(colors::green %-15s)%-25s\n" "- mx-module-ctl" "Yes" "N/A")"
                else
                        log::info "$(printf " %-50s$(colors::red %-15s)%-25s\n" "- mx-module-ctl" "No" "N/A")"
                fi
        fi
}

main "$@"
