#ifndef _BP_LINUX_VERSION_H
#define _BP_LINUX_VERSION_H
#include_next <linux/version.h>
#ifdef CONFIG_SUSE_KERNEL
#include <linux/suse_version.h>
#endif
#include <linux/osv_version.h>

#ifndef CONFIG_SUSE_KERNEL
#	define SUSE_LOCAL_VERSION_IS_GEQ(X,Y) 0
#	define SUSE_LOCAL_VERSION_IS_LESS(X,Y) 0
#	define SUSE_RELEASE_VERSION_IS_GEQ(W,X,Y,Z) 0
#	define SUSE_RELEASE_VERSION_IS_LESS(W,X,Y,Z) 0
#endif

#ifndef UBUNTU_BACKPORT_RELEASE_CODE
#	define UBUNTU_RELEASE_VERSION_IS_GEQ(X,Y) 0
#	define UBUNTU_RELEASE_VERSION_IS_LESS(X,Y) 0
#endif

#ifndef RHEL_RELEASE_VERSION
#define RHEL_RELEASE_VERSION(a,b) (((a) << 8) + (b))
#endif

#ifndef RHEL_RELEASE_CODE
#define REDHAT_RELEASE_VERSION_IS_GEQ(X,Y) 0
#define REDHAT_RELEASE_VERSION_IS_LESS(X,Y) 0
#define REDHAT_RELEASE_VERSION_IS_NOT_EQL(X,Y) 0
#define REDHAT_RELEASE_VERSION_IS_EQL(X,Y) 0
#define REDHAT_RELEASE_VERSION_IS_LEQ(X,Y) 0
#define REDHAT_RELEASE_VERSION_IS_RANGE(x1,x2, y1,y2) 0
#endif

#if defined(CONFIG_SUSE_KERNEL)
/*
* To differentiate between the different minor versions
* X - Major of minor
* Y - Minor of minor
*/
#define SUSE_LOCAL_VERSION_IS_GEQ(X,Y) SUSE_LOCALVERSION_RELEASE_CODE >= SUSE_LOCALVERSION(X,Y)
#define SUSE_LOCAL_VERSION_IS_LESS(X,Y) SUSE_LOCALVERSION_RELEASE_CODE < SUSE_LOCALVERSION(X,Y)
/*
* To differentiate between the different service packs
* X - SUSE Linux Enterprise Server
* Y - Service pack
* Z - Minor of service pack
*/
#define SUSE_RELEASE_VERSION_IS_GEQ(W,X,Y,Z) SUSE_PRODUCT_CODE >= SUSE_PRODUCT(W,X,Y,Z)
#define SUSE_RELEASE_VERSION_IS_LESS(W,X,Y,Z) SUSE_PRODUCT_CODE < SUSE_PRODUCT(W,X,Y,Z)
#elif defined(UBUNTU_BACKPORT_RELEASE_CODE)
#define UBUNTU_RELEASE_VERSION_IS_GEQ(X,Y) UBUNTU_BACKPORT_RELEASE_CODE >= UBUNTU_BACKPORT_RELEASE_VERSION(X,Y)
#define UBUNTU_RELEASE_VERSION_IS_LESS(X,Y) UBUNTU_BACKPORT_RELEASE_CODE < UBUNTU_BACKPORT_RELEASE_VERSION(X,Y)
#elif defined(RHEL_RELEASE_CODE)
/*
 * Helper macros to compare or validate versions for redhat
 * X - RHEL Major release version
 * Y - RHEL Minor release version
 * Ex: for RHEL 9.0,
 * X - 9 and Y - 0
*/
#define REDHAT_RELEASE_VERSION_IS_GEQ(X,Y) RHEL_RELEASE_CODE >= RHEL_RELEASE_VERSION(X,Y)
#define REDHAT_RELEASE_VERSION_IS_LESS(X,Y) RHEL_RELEASE_CODE < RHEL_RELEASE_VERSION(X,Y)
#define REDHAT_RELEASE_VERSION_IS_LEQ(X,Y) RHEL_RELEASE_CODE <= RHEL_RELEASE_VERSION(X,Y)
#define REDHAT_RELEASE_VERSION_IS_NOT_EQL(X,Y) RHEL_RELEASE_CODE != RHEL_RELEASE_VERSION(X,Y)
#define REDHAT_RELEASE_VERSION_IS_EQL(X,Y) RHEL_RELEASE_CODE == RHEL_RELEASE_VERSION(X,Y)
#define REDHAT_RELEASE_VERSION_IS_RANGE(x1,x2, y1,y2) \
        (REDHAT_RELEASE_VERSION_IS_GEQ(x1,x2) && REDHAT_RELEASE_VERSION_IS_LEQ(y1,y2))
#endif

#define LINUX_VERSION_IS_LESS(x1,x2,x3)	(LINUX_VERSION_CODE < KERNEL_VERSION(x1,x2,x3))
#define LINUX_VERSION_IS_GEQ(x1,x2,x3)	(LINUX_VERSION_CODE >= KERNEL_VERSION(x1,x2,x3))
#define LINUX_VERSION_IN_RANGE(x1,x2,x3, y1,y2,y3) \
	(LINUX_VERSION_IS_GEQ(x1,x2,x3) && LINUX_VERSION_IS_LESS(y1,y2,y3))

#endif /* _BP_LINUX_VERSION_H */
