#!/bin/bash
#
# Copyright (C) 2023 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#
# Authors:
#       2023  Wilson YS Huang  <wilsonys.huang@moxa.com>

source "${INSTL_SCRIPT_DIR}/lib/util.sh"
source "${INSTL_SCRIPT_DIR}/lib/logger.sh"
source "${INSTL_SCRIPT_DIR}/lib/colors.sh"
source "${INSTL_SCRIPT_DIR}/lib/driver.sh"
log::init "${INSTL_LOG_FILE}" "${INSTL_LOG_LEVEL}"

set -e

DRIVER_NAME="it87_wdt"

main() {
        if util::is_exists "$(/usr/sbin/modinfo -n ${DRIVER_NAME} 2>/dev/null)" >/dev/null 2>&1; then
                /usr/sbin/modinfo "${DRIVER_NAME}" >>"${INSTL_LOG_FILE}" 2>&1

                if drv::is_loaded "${DRIVER_NAME}"; then
                        log::info "$(printf " %-50s$(colors::green %-15s)$(colors::green %-25s)\n" "- ${DRIVER_NAME}" "Yes" "Loaded")"
                else
                        log::info "$(printf " %-50s$(colors::green %-15s)$(colors::red %-25s)\n" "- ${DRIVER_NAME}" "Yes" "Unloaded")"
                fi
        else
                log::info "$(printf " %-50s$(colors::red %-15s)%-25s\n" "- ${DRIVER_NAME}" "No" "N/A")"
        fi

        local check_wdt

        if [[ "${OS_PACKAGE_MANAGER}" == "apt" ]]; then
                check_wdt=$(
                        dpkg -s watchdog >/dev/null 2>&1
                        echo $?
                )
        elif [[ "${OS_PACKAGE_MANAGER}" == "yum" ]] && [[ "${LINUX_DISTRO_ID}" == "rhel" ]] || [[ "${LINUX_DISTRO_ID}" == "rocky" ]]; then
                check_wdt=$(
                        rpm -qa | grep -q watchdog
                        echo $?
                )
        fi

        if [[ "${LINUX_DISTRO_ID}" != "centos" ]]; then
                if [[ "$check_wdt" -eq 0 ]]; then
                        if systemctl is-enabled watchdog >/dev/null 2>&1; then
                                log::info "$(printf " %-50s$(colors::green %-15s)$(colors::green %-25s)\n" "- watchdog service" "Yes" "Enabled")"
                        else
                                log::info "$(printf " %-50s$(colors::green %-15s)$(colors::red %-25s)\n" "- watchdog service" "Yes" "Disabled")"
                        fi
                else
                        log::info "$(printf " %-50s$(colors::red %-15s)%-25s\n" "- watchdog service" "No" "N/A")"
                fi
        fi
}

main "$@"
