#include "ddk770_os.h"
#include "ddk770_reg.h"
#include "ddk770_hardware.h"
#include "ddk770_power.h"
#include "ddk770_ddkdebug.h"
#include "ddk770_hwi2c.h"
#include "ddk770_hdmi_phy.h"
#include "ddk770_hdmi.h"
#include <linux/delay.h>
#include <linux/timer.h>
#include <linux/kernel.h>

static struct phy_config phy311[] = {
	{13500, PIXEL_REPETITION_1, COLOR_DEPTH_8, 	HDMI_14, 0x0133, 0x0039, 0x0002, LT_1_485GBPS},
	{13500, PIXEL_REPETITION_1, COLOR_DEPTH_10, HDMI_14, 0x2173, 0x0039, 0x0002, LT_1_485GBPS},
	{13500, PIXEL_REPETITION_1, COLOR_DEPTH_12, HDMI_14, 0x41B3, 0x003D, 0x0002, LT_1_485GBPS},
	{13500, PIXEL_REPETITION_1, COLOR_DEPTH_16, HDMI_14, 0x6132, 0x0039, 0x0002, LT_1_485GBPS},
	{13500, PIXEL_REPETITION_3, COLOR_DEPTH_8, 	HDMI_14, 0x0132, 0x0039, 0x0002, LT_1_485GBPS},
	{13500, PIXEL_REPETITION_3, COLOR_DEPTH_10, HDMI_14, 0x2172, 0x0039, 0x0002, LT_1_485GBPS},
	{13500, PIXEL_REPETITION_3, COLOR_DEPTH_12, HDMI_14, 0x41B2, 0x003D, 0x0002, LT_1_485GBPS},
	{13500, PIXEL_REPETITION_3, COLOR_DEPTH_16, HDMI_14, 0x6131, 0x0039, 0x0002, LT_1_485GBPS},
	{13500, PIXEL_REPETITION_7, COLOR_DEPTH_8, 	HDMI_14, 0x0131, 0x0039, 0x0002, LT_1_485GBPS},
	{13500, PIXEL_REPETITION_7, COLOR_DEPTH_10, HDMI_14, 0x2171, 0x0039, 0x0002, LT_1_485GBPS},
	{13500, PIXEL_REPETITION_7, COLOR_DEPTH_12, HDMI_14, 0x41B1, 0x003D, 0x0002, LT_2_22GBPS},
	{13500, PIXEL_REPETITION_7, COLOR_DEPTH_16, HDMI_14, 0x6130, 0x0039, 0x0002, LT_2_22GBPS},
	{18000, PIXEL_REPETITION_2, COLOR_DEPTH_8, 	HDMI_14, 0x00F2, 0x0030, 0x0002, LT_1_485GBPS},
	{18000, PIXEL_REPETITION_2, COLOR_DEPTH_10, HDMI_14, 0x2162, 0x0039, 0x0002, LT_1_485GBPS},
	{18000, PIXEL_REPETITION_2, COLOR_DEPTH_12, HDMI_14, 0x41A2, 0x0039, 0x0002, LT_1_485GBPS},
	{18000, PIXEL_REPETITION_2, COLOR_DEPTH_16, HDMI_14, 0x60F1, 0x0030, 0x0002, LT_1_485GBPS},
	{18000, PIXEL_REPETITION_5, COLOR_DEPTH_8, 	HDMI_14, 0x00F1, 0x0030, 0x0002, LT_1_485GBPS},
	{18000, PIXEL_REPETITION_5, COLOR_DEPTH_10, HDMI_14, 0x2161, 0x0039, 0x0002, LT_1_485GBPS},
	{18000, PIXEL_REPETITION_5, COLOR_DEPTH_12, HDMI_14, 0x41A1, 0x0039, 0x0002, LT_2_22GBPS},
	{18000, PIXEL_REPETITION_5, COLOR_DEPTH_16, HDMI_14, 0x60F0, 0x0030, 0x0002, LT_2_22GBPS},
	{21600, PIXEL_REPETITION_4, COLOR_DEPTH_8, 	HDMI_14, 0x0151, 0x0030, 0x0002, LT_1_485GBPS},
	{21600, PIXEL_REPETITION_4, COLOR_DEPTH_12, HDMI_14, 0x4161, 0x0039, 0x0002, LT_2_22GBPS},
	{21600, PIXEL_REPETITION_4, COLOR_DEPTH_16, HDMI_14, 0x6150, 0x0030, 0x0002, LT_2_22GBPS},
	{21600, PIXEL_REPETITION_9, COLOR_DEPTH_8, 	HDMI_14, 0x0150, 0x0030, 0x0002, LT_2_22GBPS},
	{21600, PIXEL_REPETITION_9, COLOR_DEPTH_12, HDMI_14, 0x4160, 0x0039, 0x0002, LT_3_40GBPS},
	{21600, PIXEL_REPETITION_9, COLOR_DEPTH_16, HDMI_20, 0x7B70, 0x0031, 0x0003, GT_3_40GBPS},
	{24000, PIXEL_REPETITION_8, COLOR_DEPTH_8, 	HDMI_14, 0x00E0, 0x0028, 0x0002, LT_2_22GBPS},
	{24000, PIXEL_REPETITION_8, COLOR_DEPTH_16, HDMI_20, 0x7BA0, 0x0031, 0x0003, GT_3_40GBPS},
	{25175, PIXEL_REPETITION_OFF, COLOR_DEPTH_8,  HDMI_14, 0x00B3, 0x0028, 0x0002, LT_1_485GBPS},
	{25175, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_14, 0x2153, 0x0030, 0x0002, LT_1_485GBPS},
	{25175, PIXEL_REPETITION_OFF, COLOR_DEPTH_12, HDMI_14, 0x40F3, 0x0030, 0x0002, LT_1_485GBPS},
	{25175, PIXEL_REPETITION_OFF, COLOR_DEPTH_16, HDMI_14, 0x60B2, 0x0028, 0x0002, LT_1_485GBPS},
	{27000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8,  HDMI_14, 0x00B3, 0x0028, 0x0002, LT_1_485GBPS},
	{27000, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_14, 0x2153, 0x0030, 0x0002, LT_1_485GBPS},
	{27000, PIXEL_REPETITION_OFF, COLOR_DEPTH_12, HDMI_14, 0x40F3, 0x0030, 0x0002, LT_1_485GBPS},
	{27000, PIXEL_REPETITION_OFF, COLOR_DEPTH_16, HDMI_14, 0x60B2, 0x0028, 0x0002, LT_1_485GBPS},
	{27000, PIXEL_REPETITION_1, COLOR_DEPTH_8,  HDMI_14, 0x00B2, 0x0028, 0x0002, LT_1_485GBPS},
	{27000, PIXEL_REPETITION_1, COLOR_DEPTH_10, HDMI_14, 0x2152, 0x0030, 0x0002, LT_1_485GBPS},
	{27000, PIXEL_REPETITION_1, COLOR_DEPTH_12, HDMI_14, 0x40F2, 0x0030, 0x0002, LT_1_485GBPS},
	{27000, PIXEL_REPETITION_1, COLOR_DEPTH_16, HDMI_14, 0x60B1, 0x0028, 0x0002, LT_1_485GBPS},
	{27000, PIXEL_REPETITION_3, COLOR_DEPTH_8,  HDMI_14, 0x00B1, 0x0028, 0x0002, LT_1_485GBPS},
	{27000, PIXEL_REPETITION_3, COLOR_DEPTH_10, HDMI_14, 0x2151, 0x0030, 0x0002, LT_1_485GBPS},
	{27000, PIXEL_REPETITION_3, COLOR_DEPTH_12, HDMI_14, 0x40F1, 0x0030, 0x0002, LT_2_22GBPS},
	{27000, PIXEL_REPETITION_3, COLOR_DEPTH_16, HDMI_14, 0x60B0, 0x0028, 0x0002, LT_2_22GBPS},
	{27000, PIXEL_REPETITION_7, COLOR_DEPTH_8,  HDMI_14, 0x00B0, 0x0028, 0x0002, LT_2_22GBPS},
	{27000, PIXEL_REPETITION_7, COLOR_DEPTH_10, HDMI_14, 0x2150, 0x0030, 0x0002, LT_2_97GBPS},
	{27000, PIXEL_REPETITION_7, COLOR_DEPTH_12, HDMI_14, 0x40F0, 0x0030, 0x0002, LT_3_40GBPS},
	{27000, PIXEL_REPETITION_7, COLOR_DEPTH_16, HDMI_20, 0x7B30, 0x0031, 0x0003, GT_3_40GBPS},
	{31500, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x00B3, 0x0028, 0x0002, LT_1_485GBPS},
	{33750, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x00B3, 0x0028, 0x0002, LT_1_485GBPS},
	{35500, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x00B3, 0x0028, 0x0002, LT_1_485GBPS},
	{36000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x00B3, 0x0028, 0x0002, LT_1_485GBPS},
	{36000, PIXEL_REPETITION_2, COLOR_DEPTH_8,  HDMI_14, 0x00A1, 0x0028, 0x0002, LT_1_485GBPS},
	{36000, PIXEL_REPETITION_2, COLOR_DEPTH_10, HDMI_14, 0x2165, 0x0039, 0x0002, LT_1_485GBPS},
	{36000, PIXEL_REPETITION_2, COLOR_DEPTH_12, HDMI_14, 0x40E1, 0x0028, 0x0002, LT_2_22GBPS},
	{36000, PIXEL_REPETITION_2, COLOR_DEPTH_16, HDMI_14, 0x60A0, 0x0028, 0x0002, LT_2_22GBPS},
	{36000, PIXEL_REPETITION_5, COLOR_DEPTH_8,  HDMI_14, 0x00A0, 0x0028, 0x0002, LT_2_22GBPS},
	{36000, PIXEL_REPETITION_5, COLOR_DEPTH_10, HDMI_14, 0x2164, 0x0039, 0x0002, LT_2_97GBPS},
	{36000, PIXEL_REPETITION_5, COLOR_DEPTH_12, HDMI_14, 0x40E0, 0x0028, 0x0002, LT_3_40GBPS},
	{36000, PIXEL_REPETITION_5, COLOR_DEPTH_16, HDMI_20, 0x7AF0, 0x0031, 0x0003, GT_3_40GBPS},
	{40000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x00B3, 0x0028, 0x0002, LT_1_485GBPS},
	{43200, PIXEL_REPETITION_4, COLOR_DEPTH_8,   HDMI_14, 0x0140, 0x001A, 0x0002, LT_2_22GBPS},
	{43200, PIXEL_REPETITION_4, COLOR_DEPTH_12,  HDMI_14, 0x4164, 0x0039, 0x0002, LT_3_40GBPS},
	{43200, PIXEL_REPETITION_4, COLOR_DEPTH_16,  HDMI_20, 0x7B50, 0x0031, 0x0003, GT_3_40GBPS},
	{44900, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x00B3, 0x0028, 0x0002, LT_1_485GBPS},
	{49500, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0072, 0x001A, 0x0002, LT_1_485GBPS},
	{50000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0072, 0x001A, 0x0002, LT_1_485GBPS},
	{50350, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0072, 0x001A, 0x0002, LT_1_485GBPS},
	{50350, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_14, 0x2142, 0x001A, 0x0002, LT_1_485GBPS},
	{50350, PIXEL_REPETITION_OFF, COLOR_DEPTH_12, HDMI_14, 0x40A2, 0x0028, 0x0002, LT_1_485GBPS},
	{50350, PIXEL_REPETITION_OFF, COLOR_DEPTH_16, HDMI_14, 0x6071, 0x001A, 0x0002, LT_1_485GBPS},
	{54000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8,  HDMI_14, 0x0072, 0x001A, 0x0002, LT_1_485GBPS},
	{54000, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_14, 0x2142, 0x001A, 0x0002, LT_1_485GBPS},
	{54000, PIXEL_REPETITION_OFF, COLOR_DEPTH_12, HDMI_14, 0x40A2, 0x0028, 0x0002, LT_1_485GBPS},
	{54000, PIXEL_REPETITION_OFF, COLOR_DEPTH_16, HDMI_14, 0x6071, 0x001A, 0x0002, LT_1_485GBPS},
	{54000, PIXEL_REPETITION_1, COLOR_DEPTH_8,  HDMI_14, 0x0071, 0x001A, 0x0002, LT_1_485GBPS},
	{54000, PIXEL_REPETITION_1, COLOR_DEPTH_10, HDMI_14, 0x2141, 0x001A, 0x0002, LT_1_485GBPS},
	{54000, PIXEL_REPETITION_1, COLOR_DEPTH_12, HDMI_14, 0x40A1, 0x0028, 0x0002, LT_2_22GBPS},
	{54000, PIXEL_REPETITION_1, COLOR_DEPTH_16, HDMI_14, 0x6070, 0x001A, 0x0002, LT_2_22GBPS},
	{54000, PIXEL_REPETITION_3, COLOR_DEPTH_8,  HDMI_14, 0x0070, 0x001A, 0x0002, LT_2_22GBPS},
	{54000, PIXEL_REPETITION_3, COLOR_DEPTH_10, HDMI_14, 0x2140, 0x001A, 0x0002, LT_2_97GBPS},
	{54000, PIXEL_REPETITION_3, COLOR_DEPTH_12, HDMI_14, 0x40A0, 0x0028, 0x0002, LT_3_40GBPS},
	{54000, PIXEL_REPETITION_3, COLOR_DEPTH_16, HDMI_20, 0x7AB0, 0x0031, 0x0003, GT_3_40GBPS},
	{56250, PIXEL_REPETITION_OFF, COLOR_DEPTH_8,  HDMI_14, 0x0072, 0x001A, 0x0002, LT_1_485GBPS},
	{59400, PIXEL_REPETITION_OFF, COLOR_DEPTH_8,  HDMI_14, 0x0072, 0x001A, 0x0002, LT_1_485GBPS},
	{59400, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_14, 0x2142, 0x001A, 0x0002, LT_1_485GBPS},
	{59400, PIXEL_REPETITION_OFF, COLOR_DEPTH_12, HDMI_14, 0x40A2, 0x0028, 0x0002, LT_1_485GBPS},
	{59400, PIXEL_REPETITION_OFF, COLOR_DEPTH_16, HDMI_14, 0x6071, 0x001A, 0x0002, LT_1_485GBPS},
	{65000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8,  HDMI_14, 0x0072, 0x001A, 0x0002, LT_1_485GBPS},
	{68250, PIXEL_REPETITION_OFF, COLOR_DEPTH_8,  HDMI_14, 0x0072, 0x001A, 0x0002, LT_1_485GBPS},
	{71000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8,  HDMI_14, 0x0072, 0x001A, 0x0002, LT_1_485GBPS},
	{72000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8,  HDMI_14, 0x0072, 0x001A, 0x0002, LT_1_485GBPS},
	{72000, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_14, 0x2142, 0x001A, 0x0002, LT_1_485GBPS},
	{72000, PIXEL_REPETITION_OFF, COLOR_DEPTH_12, HDMI_14, 0x4061, 0x0010, 0x0002, LT_1_485GBPS},
	{72000, PIXEL_REPETITION_OFF, COLOR_DEPTH_16, HDMI_14, 0x6071, 0x001A, 0x0002, LT_1_485GBPS},
	{72000, PIXEL_REPETITION_2, COLOR_DEPTH_8,  HDMI_14, 0x0060, 0x0010, 0x0002, LT_2_22GBPS},
	{72000, PIXEL_REPETITION_2, COLOR_DEPTH_10, HDMI_14, 0x216C, 0x0039, 0x0002, LT_2_97GBPS},
	{72000, PIXEL_REPETITION_2, COLOR_DEPTH_12, HDMI_14, 0x40E4, 0x0028, 0x0002, LT_3_40GBPS},
	{72000, PIXEL_REPETITION_2, COLOR_DEPTH_16, HDMI_20, 0x7AA0, 0x0031, 0x0003, GT_3_40GBPS},
	{73250, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0072, 0x001A, 0x0002, LT_1_485GBPS},
	{74250, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0072, 0x001A, 0x0002, LT_1_485GBPS},
	{74250, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_14, 0x2145, 0x001A, 0x0002, LT_1_485GBPS},
	{74250, PIXEL_REPETITION_OFF, COLOR_DEPTH_12, HDMI_14, 0x4061, 0x0010, 0x0002, LT_1_485GBPS},
	{74250, PIXEL_REPETITION_OFF, COLOR_DEPTH_16, HDMI_14, 0x6071, 0x001A, 0x0002, LT_2_22GBPS},
	{75000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0072, 0x001A, 0x0002, LT_1_485GBPS},
	{78750, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0072, 0x001A, 0x0002, LT_1_485GBPS},
	{79500, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0072, 0x001A, 0x0002, LT_1_485GBPS},
	{82500, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0072, 0x001A, 0x0002, LT_1_485GBPS},
	{82500, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_14, 0x2145, 0x001A, 0x0002, LT_1_485GBPS},
	{82500, PIXEL_REPETITION_OFF, COLOR_DEPTH_12, HDMI_14, 0x4061, 0x0010, 0x0002, LT_1_485GBPS},
	{82500, PIXEL_REPETITION_OFF, COLOR_DEPTH_16, HDMI_14, 0x6071, 0x001A, 0x0002, LT_2_22GBPS},
	{83500, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0072, 0x001A, 0x0002, LT_1_485GBPS},
	{85500, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0072, 0x001A, 0x0002, LT_1_485GBPS},
	{88750, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0072, 0x001A, 0x0002, LT_1_485GBPS},
	{90000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0072, 0x001A, 0x0002, LT_1_485GBPS},
	{90000, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_14, 0x2145, 0x001A, 0x0002, LT_1_485GBPS},
	{90000, PIXEL_REPETITION_OFF, COLOR_DEPTH_12, HDMI_14, 0x4061, 0x0010, 0x0002, LT_1_485GBPS},
	{90000, PIXEL_REPETITION_OFF, COLOR_DEPTH_16, HDMI_14, 0x6071, 0x001A, 0x0002, LT_2_22GBPS},
	{94500, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_1_485GBPS},
	{99000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_1_485GBPS},
	{99000, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_14, 0x2145, 0x001A, 0x0002, LT_1_485GBPS},
	{99000, PIXEL_REPETITION_OFF, COLOR_DEPTH_12, HDMI_14, 0x4061, 0x0010, 0x0002, LT_2_22GBPS},
	{99000, PIXEL_REPETITION_OFF, COLOR_DEPTH_16, HDMI_14, 0x6050, 0x000A, 0x0002, LT_2_22GBPS},
	{100700, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_1_485GBPS},
	{100700, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_14, 0x2145, 0x001A, 0x0002, LT_1_485GBPS},
	{100700, PIXEL_REPETITION_OFF, COLOR_DEPTH_12, HDMI_14, 0x4061, 0x0010, 0x0002, LT_2_22GBPS},
	{100700, PIXEL_REPETITION_OFF, COLOR_DEPTH_16, HDMI_14, 0x6050, 0x000A, 0x0002, LT_2_22GBPS},
	{101000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_1_485GBPS},
	{102250, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_1_485GBPS},
	{106500, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_1_485GBPS},
	{108000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_1_485GBPS},
	{108000, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_14, 0x2145, 0x001A, 0x0002, LT_1_485GBPS},
	{108000, PIXEL_REPETITION_OFF, COLOR_DEPTH_12, HDMI_14, 0x4061, 0x0010, 0x0002, LT_2_22GBPS},
	{108000, PIXEL_REPETITION_OFF, COLOR_DEPTH_16, HDMI_14, 0x6050, 0x000A, 0x0002, LT_2_22GBPS},
	{108000, PIXEL_REPETITION_1, COLOR_DEPTH_8, HDMI_14, 0x0050, 0x000A, 0x0002, LT_2_22GBPS},
	{108000, PIXEL_REPETITION_1, COLOR_DEPTH_10, HDMI_14, 0x2144, 0x001A, 0x0002, LT_2_97GBPS},
	{108000, PIXEL_REPETITION_1, COLOR_DEPTH_12, HDMI_14, 0x4060, 0x0010, 0x0002, LT_3_40GBPS},
	{108000, PIXEL_REPETITION_1, COLOR_DEPTH_16, HDMI_20, 0x7A70, 0x0029, 0x0003, GT_3_40GBPS},
	{115500, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_1_485GBPS},
	{117500, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_1_485GBPS},
	{118800, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_1_485GBPS},
	{118800, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_14, 0x2145, 0x001A, 0x0002, LT_2_22GBPS},
	{118800, PIXEL_REPETITION_OFF, COLOR_DEPTH_12, HDMI_14, 0x4061, 0x0010, 0x0002, LT_2_22GBPS},
	{118800, PIXEL_REPETITION_OFF, COLOR_DEPTH_16, HDMI_14, 0x6050, 0x000A, 0x0002, LT_2_97GBPS},
	{119000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_1_485GBPS},
	{121750, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_1_485GBPS},
	{122500, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_1_485GBPS},
	{135000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_1_485GBPS},
	{136750, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_1_485GBPS},
	{140250, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_1_485GBPS},
	{144000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_1_485GBPS},
	{144000, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_14, 0x2145, 0x001A, 0x0002, LT_2_22GBPS},
	{144000, PIXEL_REPETITION_OFF, COLOR_DEPTH_12, HDMI_14, 0x4064, 0x0010, 0x0002, LT_2_22GBPS},
	{144000, PIXEL_REPETITION_OFF, COLOR_DEPTH_16, HDMI_14, 0x6050, 0x000A, 0x0002, LT_2_97GBPS},
	{146250, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_1_485GBPS},
	{148250, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_1_485GBPS},
	{148500, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_2_22GBPS},
	{148500, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_14, 0x214C, 0x001A, 0x0002, LT_2_22GBPS},
	{148500, PIXEL_REPETITION_OFF, COLOR_DEPTH_12, HDMI_14, 0x4064, 0x0010, 0x0002, LT_2_97GBPS},
	{148500, PIXEL_REPETITION_OFF, COLOR_DEPTH_16, HDMI_14, 0x6050, 0x000A, 0x0002, LT_3_40GBPS},
	{154000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_2_22GBPS},
	{156000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_2_22GBPS},
	{157000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_2_22GBPS},
	{157500, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_2_22GBPS},
	{162000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_2_22GBPS},
	{165000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_2_22GBPS},
	{165000, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_14, 0x214C, 0x001A, 0x0002, LT_2_22GBPS},
	{165000, PIXEL_REPETITION_OFF, COLOR_DEPTH_12, HDMI_14, 0x4064, 0x0010, 0x0002, LT_2_97GBPS},
	{165000, PIXEL_REPETITION_OFF, COLOR_DEPTH_16, HDMI_14, 0x6050, 0x000A, 0x0002, LT_3_40GBPS},
	{175500, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_2_22GBPS},
	{179500, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_2_22GBPS},
	{180000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_2_22GBPS},
	{180000, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_14, 0x214C, 0x001A, 0x0002, LT_2_97GBPS},
	{180000, PIXEL_REPETITION_OFF, COLOR_DEPTH_12, HDMI_14, 0x4064, 0x0010, 0x0002, LT_2_97GBPS},
	{180000, PIXEL_REPETITION_OFF, COLOR_DEPTH_16, HDMI_20, 0x7A50, 0x0011, 0x0003, GT_3_40GBPS},
	{182750, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0051, 0x000A, 0x0002, LT_2_22GBPS},
	{185625, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_2_22GBPS},
	{185625, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_14, 0x214C, 0x001A, 0x0002, LT_2_97GBPS},
	{185625, PIXEL_REPETITION_OFF, COLOR_DEPTH_12, HDMI_14, 0x4064, 0x0010, 0x0002, LT_2_97GBPS},
	{185625, PIXEL_REPETITION_OFF, COLOR_DEPTH_16, HDMI_20, 0x7A50, 0x0011, 0x0003, GT_3_40GBPS},
	{187000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_2_22GBPS},
	{187250, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_2_22GBPS},
	{189000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_2_22GBPS},
	{193250, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_2_22GBPS},
	{198000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_2_22GBPS},
	{198000, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_14, 0x214C, 0x001A, 0x0002, LT_2_97GBPS},
	{198000, PIXEL_REPETITION_OFF, COLOR_DEPTH_12, HDMI_14, 0x4064, 0x0010, 0x0002, LT_3_40GBPS},
	{198000, PIXEL_REPETITION_OFF, COLOR_DEPTH_16, HDMI_20, 0x7A50, 0x0011, 0x0003, GT_3_40GBPS},
	{202500, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_2_22GBPS},
	{204750, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_2_22GBPS},
	{208000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_2_22GBPS},
	{214750, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_2_22GBPS},
	{216000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_2_22GBPS},
	{216000, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_14, 0x214C, 0x001A, 0x0002, LT_2_97GBPS},
	{216000, PIXEL_REPETITION_OFF, COLOR_DEPTH_12, HDMI_14, 0x4064, 0x0010, 0x0002, LT_3_40GBPS},
	{216000, PIXEL_REPETITION_OFF, COLOR_DEPTH_16, HDMI_20, 0x7A50, 0x0011, 0x0003, GT_3_40GBPS},
	{218250, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_2_22GBPS},
	{229500, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_2_97GBPS},
	{234000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_2_97GBPS},
	{237600, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_2_97GBPS},
	{237600, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_14, 0x214C, 0x001A, 0x0002, LT_3_40GBPS},
	{237600, PIXEL_REPETITION_OFF, COLOR_DEPTH_12, HDMI_20, 0x5A64, 0x0019, 0x0003, GT_3_40GBPS},
	{237600, PIXEL_REPETITION_OFF, COLOR_DEPTH_16, HDMI_20, 0x7A50, 0x0011, 0x0003, GT_3_40GBPS},
	{245250, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_2_97GBPS},
	{245500, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_2_97GBPS},
	{261000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_2_97GBPS},
	{268250, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_2_97GBPS},
	{268500, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_2_97GBPS},
	{281250, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_2_97GBPS},
	{288000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_2_97GBPS},
	{288000, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_20, 0x3B4C, 0x0031, 0x0003, GT_3_40GBPS},
	{288000, PIXEL_REPETITION_OFF, COLOR_DEPTH_12, HDMI_20, 0x5A64, 0x0019, 0x0003, GT_3_40GBPS},
	{288000, PIXEL_REPETITION_OFF, COLOR_DEPTH_16, HDMI_20, 0x7A50, 0x0011, 0x0003, GT_3_40GBPS},
	{297000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_3_40GBPS},
	{297000, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_20, 0x3B4C, 0x0031, 0x0003, GT_3_40GBPS},
	{297000, PIXEL_REPETITION_OFF, COLOR_DEPTH_12, HDMI_20, 0x5A64, 0x0019, 0x0003, GT_3_40GBPS},
	{297000, PIXEL_REPETITION_OFF, COLOR_DEPTH_16, HDMI_20, 0x7A50, 0x0011, 0x0003, GT_3_40GBPS},
	{317000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_3_40GBPS},
	{330000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_3_40GBPS},
	{330000, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_20, 0x3B4C, 0x0031, 0x0003, GT_3_40GBPS},
	{330000, PIXEL_REPETITION_OFF, COLOR_DEPTH_12, HDMI_20, 0x5A64, 0x0019, 0x0003, GT_3_40GBPS},
	{333250, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_3_40GBPS},
	{340000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_3_40GBPS},
	{348500, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_20, 0x1A40, 0x003f, 0x0003, GT_3_40GBPS},
	{356500, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_20, 0x1A40, 0x003f, 0x0003, GT_3_40GBPS},
	{360000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_20, 0x1A40, 0x003f, 0x0003, GT_3_40GBPS},
	{360000, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_20, 0x3B4C, 0x0031, 0x0003, GT_3_40GBPS},
	{360000, PIXEL_REPETITION_OFF, COLOR_DEPTH_12, HDMI_20, 0x5A64, 0x0019, 0x0003, GT_3_40GBPS},
	{371250, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_20, 0x1A40, 0x003f, 0x0003, GT_3_40GBPS},
	{371250, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_20, 0x3B4C, 0x0031, 0x0003, GT_3_40GBPS},
	{371250, PIXEL_REPETITION_OFF, COLOR_DEPTH_12, HDMI_20, 0x5A64, 0x0019, 0x0003, GT_3_40GBPS},
	{281250, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_14, 0x0040, 0x0001, 0x0002, LT_2_97GBPS},
	{396000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_20, 0x1A40, 0x003f, 0x0003, GT_3_40GBPS},
	{396000, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_20, 0x3B4C, 0x0031, 0x0003, GT_3_40GBPS},
	{396000, PIXEL_REPETITION_OFF, COLOR_DEPTH_12, HDMI_20, 0x5A64, 0x0019, 0x0003, GT_3_40GBPS},
	{432000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_20, 0x1A40, 0x003f, 0x0003, GT_3_40GBPS},
	{432000, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_20, 0x3B4C, 0x0031, 0x0003, GT_3_40GBPS},
	{380500, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_20, 0x1A40, 0x003f, 0x0003, GT_3_40GBPS},
	{475200, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_20, 0x1A40, 0x003f, 0x0003, GT_3_40GBPS},
	{475200, PIXEL_REPETITION_OFF, COLOR_DEPTH_10, HDMI_20, 0x3B4C, 0x0031, 0x0003, GT_3_40GBPS},
	{495000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_20, 0x1A40, 0x003f, 0x0003, GT_3_40GBPS},
	{505250, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_20, 0x1A40, 0x003f, 0x0003, GT_3_40GBPS},
	{552750, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_20, 0x1A40, 0x003f, 0x0003, GT_3_40GBPS},
	{580000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_20, 0x1A40, 0x003f, 0x0003, GT_3_40GBPS},
	{594000, PIXEL_REPETITION_OFF, COLOR_DEPTH_8, HDMI_20, 0x1A40, 0x003f, 0x0003, GT_3_40GBPS},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0}

};

static int u32_fabs(int x) {
    if (x < 0) {
        return -x;
    }
    return x;
}

u8 u32_is_equal(u32 a, u32 b){
		
    return (u32_fabs((int)a-(int)b) < 5);

}


void ddk770_HDMI_phy_i2c_slave_address(hdmi_index index, u8 value)
{
	
	ddk770_HDMI_write_mask(index, PHY_I2CM_SLAVE, PHY_I2CM_SLAVE_SLAVEADDR_MASK, value);
}

int ddk770_HDMI_phy_i2c_write(hdmi_index index, u8 addr, u16 data)
{
	int timeout = PHY_TIMEOUT;
	u32 status  = 0;

	//Set address
	ddk770_HDMI_Write_Register(index, PHY_I2CM_ADDRESS, addr);   // phy_i2cm_address (OPMODE_PLLCFG)

	//Set value
    ddk770_HDMI_Write_Register(index, PHY_I2CM_DATAO_0, (u8) (data & 0xFF));          // phy_i2cm_datao_0
    ddk770_HDMI_Write_Register(index, PHY_I2CM_DATAO_1, (u8) ((data >> 8) & 0xFF));   // phy_i2cm_datao_1
	

	ddk770_HDMI_Write_Register(index, PHY_I2CM_OPERATION, PHY_I2CM_OPERATION_WR_MASK);   // phy_i2cm_operation

	do {
	    usleep_range(10000, 11000);
		status = ddk770_HDMI_read_mask(index, IH_I2CMPHY_STAT0, IH_I2CMPHY_STAT0_I2CMPHYERROR_MASK |
							     IH_I2CMPHY_STAT0_I2CMPHYDONE_MASK);
	} while (status == 0 && (timeout--));

	ddk770_HDMI_Write_Register(index, IH_I2CMPHY_STAT0, status); //clear read status

	if(status & IH_I2CMPHY_STAT0_I2CMPHYERROR_MASK){
		return -1;
	}

	if(status & IH_I2CMPHY_STAT0_I2CMPHYDONE_MASK){
		return 0;
	}

	return -1;
}

int ddk770_HDMI_phy_i2c_read(hdmi_index index, u8 addr, u16 * value)
{
	int timeout = PHY_TIMEOUT;
	u32 status  = 0;

	//Set address
	ddk770_HDMI_Write_Register(index, PHY_I2CM_ADDRESS, addr);

	ddk770_HDMI_Write_Register(index, PHY_I2CM_OPERATION, PHY_I2CM_OPERATION_RD_MASK);

	do {
		usleep_range(10000, 11000);
		status = ddk770_HDMI_read_mask(index, IH_I2CMPHY_STAT0, IH_I2CMPHY_STAT0_I2CMPHYERROR_MASK |
													  IH_I2CMPHY_STAT0_I2CMPHYDONE_MASK);
	} while (status == 0 && (timeout--));

	ddk770_HDMI_Write_Register(index, IH_I2CMPHY_STAT0, status); //clear read status

	if(status & IH_I2CMPHY_STAT0_I2CMPHYERROR_MASK){
		return -1;
	}

	if(status & IH_I2CMPHY_STAT0_I2CMPHYDONE_MASK){

		*value = ((u16) (ddk770_HDMI_Read_Register(index, (PHY_I2CM_DATAI_1)) << 8)
				| ddk770_HDMI_Read_Register(index, (PHY_I2CM_DATAI_0)));
		return 0;
	}

	
	return -1;
}



static u32 phy_get_freq(u32 pClk)
{

	if(((pClk >= 25175) && (pClk <= 25180)) || ((pClk >= 25195) && (pClk <= 25205)))
		return 25175;
	else if (((pClk >= 26995) && (pClk <= 27005)) || ((pClk >= 27022) && (pClk <= 27032)))
		return 27000;
	else if (u32_is_equal(pClk, 31500))
		return 31500;
	else if (u32_is_equal(pClk,  33750))
		return 33750;
	else if (u32_is_equal(pClk,  35500))
		return 35500;
	else if (((pClk >= 35995) && (pClk <= 36005)) || ((pClk >= 36031) && (pClk <= 36041)))
		return 36000;
	else if (u32_is_equal(pClk,  40000))
		return 40000;
	else if (u32_is_equal(pClk,  44900))
		return 44900;
	else if (u32_is_equal(pClk,  49500))
		return 49500;
	else if (u32_is_equal(pClk,  50000))
		return 50000;
	else if (((pClk >= 50345) && (pClk <= 50355)) || ((pClk >= 50395) && (pClk <= 50405)))
		return 50350;
	else if (((pClk >= 53995) && (pClk <= 54005)) || ((pClk >= 50049) && (pClk <= 54059)))
		return 54000;
	else if (u32_is_equal(pClk,  56250))
		return 56250;
	else if (((pClk >= 59336) && (pClk <= 59346)) || ((pClk >= 59395) && (pClk <= 59405)))
		return 59400;
	else if (u32_is_equal(pClk,  65000))
		return 65000;
	else if (u32_is_equal(pClk,  68250))
		return 68250;
	else if (u32_is_equal(pClk,  71000))
		return 71000;
	else if (u32_is_equal(pClk,  72000))
		return 72000;
	else if (u32_is_equal(pClk,  73250))
		return 73250;
	else if (((pClk >= 74171) && (pClk <= 74181)) || ((pClk >= 74245) && (pClk <= 74255)))
		return 74250;
	else if (u32_is_equal(pClk,  75000))
		return 75000;
	else if (u32_is_equal(pClk,  78750))
		return 78750;
	else if (u32_is_equal(pClk,  79500))
		return 79500;
	else if (((pClk >= 82143) && (pClk <= 82153)) || ((pClk >= 82495) && (pClk <= 82505)))
		return 82500;
	else if (u32_is_equal(pClk,  83500))
		return 83500;
	else if (u32_is_equal(pClk,  85500))
		return 85500;
	else if (u32_is_equal(pClk,  88750))
		return 88750;
	else if (u32_is_equal(pClk,  90000))
		return 90000;
	else if (u32_is_equal(pClk,  94500))
		return 94500;
	else if (((pClk >= 98896) && (pClk <= 98906)) || ((pClk >= 98995) && (pClk <= 99005)))
		return 99000;
	else if (((pClk >= 100695) && (pClk <= 100705)) || ((pClk >= 100795) && (pClk <= 100805)))
		return 100700;
	else if (u32_is_equal(pClk, 101000))
		return 101000;
	else if (u32_is_equal(pClk, 102250))
		return 102250;
	else if (u32_is_equal(pClk, 106500))
		return 106500;
	else if (((pClk >= 107995) && (pClk <= 108005)) || ((pClk >= 108103) && (pClk <= 108113)))
		return 108000;
	else if (u32_is_equal(pClk, 115500))
		return 115500;
	else if (u32_is_equal(pClk, 117500))
		return 117500;
	else if (((pClk >= 118795) && (pClk <= 118805)) || ((pClk >= 118677) && (pClk <= 118687)))
		return 118800;
	else if (u32_is_equal(pClk, 119000))
		return 119000;
	else if (u32_is_equal(pClk, 121750))
		return 122500;
	else if (u32_is_equal(pClk, 122500))
		return 121750;
	else if (u32_is_equal(pClk, 135000))
		return 135000;
	else if (u32_is_equal(pClk, 136750))
		return 136750;
	else if (u32_is_equal(pClk, 140250))
		return 140250;
	else if (u32_is_equal(pClk, 144000))
		return 144000;
	else if (u32_is_equal(pClk, 146250))
		return 146250;
	else if (u32_is_equal(pClk, 148250))
		return 148250;
	else if (((pClk >= 148347) && (pClk <= 148357)) || ((pClk >= 148495) && (pClk <= 148505)))
		return 148500;
	else if (u32_is_equal(pClk, 154000))
		return 154000;
	else if (u32_is_equal(pClk, 156000))
		return 156000;
	else if (u32_is_equal(pClk, 157000))
		return 157000;
	else if (u32_is_equal(pClk, 157500))
		return 157500;
	else if (u32_is_equal(pClk, 162000))
		return 162000;
	else if (((pClk >= 164830) && (pClk <= 164840)) || ((pClk >= 164995) && (pClk <= 165005)))
		return 165000;
	else if (u32_is_equal(pClk, 175500))
		return 175500;
	else if (u32_is_equal(pClk, 179500))
		return 179500;
	else if (u32_is_equal(pClk, 180000))
		return 180000;
	else if (u32_is_equal(pClk, 182750))
		return 182750;
	else if (((pClk >= 185435) && (pClk <= 185445)) || ((pClk >= 185620) && (pClk <= 185630)))
		return 185625;
	else if (u32_is_equal(pClk, 187000))
		return 187000;
	else if (u32_is_equal(pClk, 187250))
		return 187250;
	else if (u32_is_equal(pClk, 189000))
		return 189000;
	else if (u32_is_equal(pClk, 193250))
		return 193250;
	else if (((pClk >= 197797) && (pClk <= 197807)) || ((pClk >= 197995) && (pClk <= 198005)))
		return 198000;
	else if (u32_is_equal(pClk, 202500))
		return 202500;
	else if (u32_is_equal(pClk, 204750))
		return 204750;
	else if (u32_is_equal(pClk, 208000))
		return 208000;
	else if (u32_is_equal(pClk, 214750))
		return 214750;
	else if (((pClk >= 216211) && (pClk <= 216221)) || ((pClk >= 215995) && (pClk <= 216005)))
		return 216000;
	else if (u32_is_equal(pClk, 218250))
		return 218250;
	else if (u32_is_equal(pClk, 229500))
		return 229500;
	else if (u32_is_equal(pClk, 234000))
		return 234000;
	else if (((pClk >= 237359) && (pClk <= 237369)) || ((pClk >= 237595) && (pClk <= 237605)))
		return 237600;
	else if (u32_is_equal(pClk, 245250))
		return 245250;
	else if (u32_is_equal(pClk, 245500))
		return 245500;
	else if (u32_is_equal(pClk, 261000))
		return 261000;
	else if (u32_is_equal(pClk, 268250))
		return 268250;
	else if (u32_is_equal(pClk, 268500))
		return 268500;
	else if (u32_is_equal(pClk, 281250))
		return 281250;
	else if (u32_is_equal(pClk, 288000))
		return 288000;
	else if (((pClk >= 296698) && (pClk <= 296708)) || ((pClk >= 296995) && (pClk <= 297005)))
		return 297000;
	else if (u32_is_equal(pClk, 317000))
		return 317000;
	else if (u32_is_equal(pClk, 330000))
		return 330000;
	else if (u32_is_equal(pClk, 333250))
		return 333250;
	else if (((pClk >= 339655) && (pClk <= 339665)) || ((pClk >= 339995) && (pClk <= 340005)))
		return 340000;
	else if (u32_is_equal(pClk, 348500))
		return 348500;
	else if (u32_is_equal(pClk, 356500))
		return 356500;
	else if (u32_is_equal(pClk, 360000))
		return 360000;
	else if (((pClk >= 370874) && (pClk <= 370884)) || ((pClk >= 371245) && (pClk <= 371255)))
		return 371250;
	else if (u32_is_equal(pClk, 380500))
		return 380500;
	else if (((pClk >= 395599) && (pClk <= 395609)) || ((pClk >= 395995) && (pClk <= 396005)))
		return 396000;
	else if (((pClk >= 431952) && (pClk <= 431967)) || ((pClk >= 431995) && (pClk <= 432005)) || ((pClk >= 432427) && (pClk <= 432437)))
		return 432000;
	else if (u32_is_equal(pClk, 443250))
		return 443250;
	else if (((pClk >= 475148) && (pClk <= 475158)) || ((pClk >= 475195) && (pClk <= 475205)) || ((pClk >= 474723) && (pClk <= 474733)))
		return 475200;
	else if (((pClk >= 494500) && (pClk <= 494510)) || ((pClk >= 494995) && (pClk <= 495005)))
		return 495000;
	else if (u32_is_equal(pClk, 505250))
		return 505250;
	else if (u32_is_equal(pClk, 552750))
		return 552750;
	else if (((pClk >= 579995) && (pClk <= 580005)) || ((pClk >= 579403) && (pClk <= 579413)))
		return 580000;
	else if (((pClk >= 593995) && (pClk <= 594005)) || ((pClk >= 593403) && (pClk <= 593413)))
		return 594000;

	//If it is not matched, the loan is required

	else if ((pClk >= 345500) && (pClk <= 600000))
		return 594000;
	else if ((pClk >= 183000) && (pClk < 345500))
		return 297000;
	else if ((pClk >= 92000) && (pClk < 183000))
	{
		return 148500;
	}
	else if ((pClk >= 45000) && (pClk < 92000))
		return 85500;
	else if ((pClk >= 15000) && (pClk < 45000))
		return 36000;

	else{
		printk("Unable to map input pixel clock frequency %dMHz\n", pClk);
	}
	return 1000;

}

void ddk770_HDMI_phy_interrupt_mask(hdmi_index index, u8 mask)
{
	// Mask will determine which bits will be enabled
	ddk770_HDMI_write_mask(index, PHY_MASK0, mask, 0xff);
}

void ddk770_HDMI_phy_interrupt_unmask(hdmi_index index, u8 mask)
{
	// Mask will determine which bits will be enabled
	ddk770_HDMI_write_mask(index, PHY_MASK0, mask, 0x0);
}

static int phy_interrupt_enable(hdmi_index index, u8 value)
{
	
	ddk770_HDMI_Write_Register(index, PHY_MASK0, value);
	return 1;
}

__attribute__((unused)) static void ddk770_HDMI_phy_disable(hdmi_index index)
{

	ddk770_HDMI_Write_Register(index, 0x3000, 0x32);
}


static void _power_down(hdmi_index index, u8 bit)
{

	ddk770_HDMI_write_mask(index, PHY_CONF0, PHY_CONF0_SPARES_2_MASK, (bit ? 1 : 0));
}


static void phy_enable_hpd_sense(hdmi_index index, u8 bit)
{

	ddk770_HDMI_write_mask(index, PHY_CONF0, PHY_CONF0_ENHPDRXSENSE_MASK, (bit ? 1 : 0));
}


static void _enable_tmds(hdmi_index index, u8 bit)
{


	ddk770_HDMI_write_mask(index, PHY_CONF0, PHY_CONF0_SPARES_1_MASK, (bit ? 1 : 0));
}

static void _set_pddq(hdmi_index index, u8 bit)
{

	ddk770_HDMI_write_mask(index, PHY_CONF0, PHY_CONF0_PDDQ_MASK, (bit ? 1 : 0));
}

static void _tx_power_on(hdmi_index index, u8 bit)
{

	ddk770_HDMI_write_mask(index, PHY_CONF0, PHY_CONF0_TXPWRON_MASK, (bit ? 1 : 0));
}


static void _data_enable_polarity(hdmi_index index, u8 bit)
{

	ddk770_HDMI_write_mask(index, PHY_CONF0, PHY_CONF0_SELDATAENPOL_MASK, (bit ? 1 : 0));
}

static void _interface_control(hdmi_index index, u8 bit)
{

	ddk770_HDMI_write_mask(index, PHY_CONF0, PHY_CONF0_SELDIPIF_MASK, (bit ? 1 : 0));
}

static void phy_i2c_mask_interrupts(hdmi_index index, int mask)
{

	ddk770_HDMI_write_mask(index, PHY_I2CM_INT, PHY_I2CM_INT_DONE_MASK_MASK, mask ? 1 : 0);
	ddk770_HDMI_write_mask(index, PHY_I2CM_CTLINT, PHY_I2CM_CTLINT_ARBITRATION_MASK_MASK, mask ? 1 : 0);
	ddk770_HDMI_write_mask(index, PHY_I2CM_CTLINT, PHY_I2CM_CTLINT_NACK_MASK_MASK, mask ? 1 : 0);
}


static void phy_interrupt_unmask_bit(hdmi_index index,unsigned char bit_mask)
{

	ddk770_HDMI_write_mask(index, IH_MUTE_PHY_STAT0, bit_mask, 0);
}



void irq_hpd_sense_enable(hdmi_index index)
{
	u32 mask;

	/* Set i2cddc to standard mode */
	ddk770_HDMI_write_mask(index, I2CM_DIV, I2CM_DIV_FAST_STD_MODE_MASK, 0);


	// Enable HDMI TX PHY HPD Detector
	phy_enable_hpd_sense(index, 1);

	// Un-mask the HPD sense
	mask = IH_MUTE_PHY_STAT0_HPD_MASK;
#if 0
	mask |= IH_MUTE_PHY_STAT0_RX_SENSE_0_MASK;
	mask |= IH_MUTE_PHY_STAT0_RX_SENSE_1_MASK;
	mask |= IH_MUTE_PHY_STAT0_RX_SENSE_2_MASK;
	mask |= IH_MUTE_PHY_STAT0_RX_SENSE_3_MASK;
#endif
	phy_interrupt_unmask_bit(index, mask);


	// Un-mask the PHY_mask register - hpd bit
	mask = PHY_MASK0_HPD_MASK;
#if 0
	mask |= PHY_MASK0_RX_SENSE_0_MASK;
	mask |= PHY_MASK0_RX_SENSE_1_MASK;
	mask |= PHY_MASK0_RX_SENSE_2_MASK;
	mask |= PHY_MASK0_RX_SENSE_3_MASK;
#endif
	phy_interrupt_enable(index, ~mask);

	// Un-mask main interrupt
	// ddk770_HDMI_Intr_Mute(index,0);
}


int phy_hot_plug_detected(hdmi_index index)
{
	/* MASK         STATUS          POLARITY        INTERRUPT        HPD
	 *   0             0                 0               1             0
	 *   0             1                 0               0             1
	 *   0             0                 1               0             0
	 *   0             1                 1               1             1
	 *   1             x                 x               0             x
	 */

	int hpd_polarity = ddk770_HDMI_read_mask(index, PHY_POL0, PHY_POL0_HPD_MASK);
	int hpd = ddk770_HDMI_read_mask(index, PHY_STAT0, PHY_STAT0_HPD_MASK);

	// Mask interrupt
	ddk770_HDMI_phy_interrupt_mask(index, PHY_MASK0_HPD_MASK);

	if (hpd_polarity == hpd) {
		ddk770_HDMI_write_mask(index, PHY_POL0, PHY_POL0_HPD_MASK, !hpd_polarity);

		// Un-mask interrupts
		ddk770_HDMI_write_mask(index, PHY_MASK0, PHY_MASK0_HPD_MASK, 0x0);

		return hpd_polarity;
	}

	// Un-mask interrupts
	ddk770_HDMI_write_mask(index, PHY_MASK0, PHY_MASK0_HPD_MASK, 0x0);

	return !hpd_polarity;
}


__attribute__((unused)) static int phy_rx_s0_detected(hdmi_index index)
{
	/* MASK         STATUS          POLARITY        INTERRUPT        RxS
	 *   0             0                 0               1             0
	 *   0             1                 0               0             1
	 *   0             0                 1               0             0
	 *   0             1                 1               1             1
	 *   1             x                 x               0             x
	 */

	int RxS_polarity = ddk770_HDMI_read_mask(index, PHY_POL0, PHY_POL0_RX_SENSE_0_MASK);
	int RxS = ddk770_HDMI_read_mask(index, PHY_STAT0, PHY_STAT0_RX_SENSE_0_MASK);

	// Mask interrupt
	ddk770_HDMI_phy_interrupt_mask(index, PHY_MASK0_RX_SENSE_0_MASK);

	if (RxS_polarity == RxS) {
		ddk770_HDMI_write_mask(index, PHY_POL0, PHY_POL0_RX_SENSE_0_MASK, !RxS_polarity);

		// Un-mask interrupts
		ddk770_HDMI_phy_interrupt_unmask(index, PHY_MASK0_RX_SENSE_0_MASK);

		return RxS_polarity;
	}

	// Un-mask interrupts
	ddk770_HDMI_phy_interrupt_unmask(index, PHY_MASK0_RX_SENSE_0_MASK);

	return !RxS_polarity;
}

__attribute__((unused)) static int phy_rx_s1_detected(hdmi_index index)
{
	/* MASK         STATUS          POLARITY        INTERRUPT        RxS
	 *   0             0                 0               1             0
	 *   0             1                 0               0             1
	 *   0             0                 1               0             0
	 *   0             1                 1               1             1
	 *   1             x                 x               0             x
	 */

	int RxS_polarity = ddk770_HDMI_read_mask(index, PHY_POL0, PHY_POL0_RX_SENSE_1_MASK);
	int RxS = ddk770_HDMI_read_mask(index, PHY_STAT0, PHY_STAT0_RX_SENSE_1_MASK);

	// Mask interrupt
	ddk770_HDMI_phy_interrupt_mask(index, PHY_MASK0_RX_SENSE_1_MASK);

	if (RxS_polarity == RxS) {
		ddk770_HDMI_write_mask(index, PHY_POL0, PHY_POL0_RX_SENSE_1_MASK, !RxS_polarity);

		// Un-mask interrupts
		ddk770_HDMI_phy_interrupt_unmask(index, PHY_MASK0_RX_SENSE_1_MASK);

		return RxS_polarity;
	}

	// Un-mask interrupts
	ddk770_HDMI_phy_interrupt_unmask(index, PHY_MASK0_RX_SENSE_1_MASK);

	return !RxS_polarity;
}

__attribute__((unused)) static int phy_rx_s2_detected(hdmi_index index)
{
	/* MASK         STATUS          POLARITY        INTERRUPT        RxS
	 *   0             0                 0               1             0
	 *   0             1                 0               0             1
	 *   0             0                 1               0             0
	 *   0             1                 1               1             1
	 *   1             x                 x               0             x
	 */

	int RxS_polarity = ddk770_HDMI_read_mask(index, PHY_POL0, PHY_POL0_RX_SENSE_2_MASK);
	int RxS = ddk770_HDMI_read_mask(index, PHY_STAT0, PHY_STAT0_RX_SENSE_2_MASK);

	// Mask interrupt
	ddk770_HDMI_phy_interrupt_mask(index, PHY_MASK0_RX_SENSE_2_MASK);

	if (RxS_polarity == RxS) {
		ddk770_HDMI_write_mask(index, PHY_POL0, PHY_POL0_RX_SENSE_2_MASK, !RxS_polarity);

		// Un-mask interrupts
		ddk770_HDMI_phy_interrupt_unmask(index, PHY_MASK0_RX_SENSE_2_MASK);

		return RxS_polarity;
	}

	// Un-mask interrupts
	ddk770_HDMI_phy_interrupt_unmask(index, PHY_MASK0_RX_SENSE_2_MASK);

	return !RxS_polarity;
}

__attribute__((unused)) static int phy_rx_s3_detected(hdmi_index index)
{
	/* MASK         STATUS          POLARITY        INTERRUPT        RxS
	 *   0             0                 0               1             0
	 *   0             1                 0               0             1
	 *   0             0                 1               0             0
	 *   0             1                 1               1             1
	 *   1             x                 x               0             x
	 */

	int RxS_polarity = ddk770_HDMI_read_mask(index, PHY_POL0, PHY_POL0_RX_SENSE_3_MASK);
	int RxS = ddk770_HDMI_read_mask(index, PHY_STAT0, PHY_STAT0_RX_SENSE_3_MASK);

	// Mask interrupt
	ddk770_HDMI_phy_interrupt_mask(index, PHY_MASK0_RX_SENSE_3_MASK);

	if (RxS_polarity == RxS) {
		ddk770_HDMI_write_mask(index, PHY_POL0, PHY_POL0_RX_SENSE_3_MASK, !RxS_polarity);

		// Un-mask interrupts
		ddk770_HDMI_phy_interrupt_unmask(index, PHY_MASK0_RX_SENSE_3_MASK);

		return RxS_polarity;
	}

	// Un-mask interrupts
	ddk770_HDMI_phy_interrupt_unmask(index, PHY_MASK0_RX_SENSE_3_MASK);

	return !RxS_polarity;
}


int decode_is_phy(u32 decode)
{
	return (decode & IH_DECODE_IH_PHY_MASK) ? 1 : 0;
}

int decode_is_phy_hpd(u32 decode)
{
	return (decode & IH_PHY_STAT0_HPD_MASK) ? 1 : 0;
}

__attribute__((unused)) static int decode_is_phy_rx_s0(u32 decode)
{
	return (decode & IH_PHY_STAT0_RX_SENSE_0_MASK) ? 1 : 0;
}

__attribute__((unused)) static int decode_is_phy_rx_s1(u32 decode)
{
	return (decode & IH_PHY_STAT0_RX_SENSE_1_MASK) ? 1 : 0;
}

__attribute__((unused)) static int decode_is_phy_rx_s2(u32 decode)
{
	return (decode & IH_PHY_STAT0_RX_SENSE_2_MASK) ? 1 : 0;
}

__attribute__((unused)) static int decode_is_phy_rx_s3(u32 decode)
{
	return (decode & IH_PHY_STAT0_RX_SENSE_3_MASK) ? 1 : 0;
}


u32 read_interrupt_decode(hdmi_index index)
{
	return (ddk770_HDMI_Read_Register(index, IH_DECODE) & 0xFF);
}

static u8 phy_rx_s0_state(hdmi_index index)
{
	
	return ddk770_HDMI_read_mask(index, (PHY_STAT0), PHY_STAT0_RX_SENSE_0_MASK);
}

static u8 phy_rx_s1_state(hdmi_index index)
{

	return ddk770_HDMI_read_mask(index, (PHY_STAT0), PHY_STAT0_RX_SENSE_1_MASK);
}
static u8 phy_rx_s2_state(hdmi_index index)
{

	return ddk770_HDMI_read_mask(index, (PHY_STAT0), PHY_STAT0_RX_SENSE_2_MASK);
}

static u8 phy_rx_s3_state(hdmi_index index)
{

	return ddk770_HDMI_read_mask(index, (PHY_STAT0), PHY_STAT0_RX_SENSE_3_MASK);
}

u8 phy_rx_sense_state(hdmi_index index)
{
	u8 state;
	state = phy_rx_s0_state(index);
	state |= phy_rx_s1_state(index);
	state |= phy_rx_s2_state(index);
	state |= phy_rx_s3_state(index);
	return state;
}



u8 phy_hot_plug_state(hdmi_index index)
{
	return ddk770_HDMI_read_mask(index, (PHY_STAT0), PHY_STAT0_HPD_MASK);
}


int phy_standby(hdmi_index index)
{
	ddk770_HDMI_phy_interrupt_mask(index, PHY_MASK0_TX_PHY_LOCK_MASK |
				PHY_MASK0_RX_SENSE_0_MASK |
				PHY_MASK0_RX_SENSE_1_MASK |
				PHY_MASK0_RX_SENSE_2_MASK |
				PHY_MASK0_RX_SENSE_3_MASK);	/* mask phy interrupts - leave HPD */
	_enable_tmds(index, 0);
	_power_down(index, 0);	/*  disable PHY */
	_tx_power_on(index, 0);
	_set_pddq(index, 1);

	return 1;
}



int phy_initialize(hdmi_index index)
{
    _tx_power_on(index, 0);
	_set_pddq(index, 1);

	ddk770_HDMI_phy_interrupt_mask(index, PHY_MASK0_TX_PHY_LOCK_MASK |
				PHY_MASK0_HPD_MASK |
				PHY_MASK0_RX_SENSE_0_MASK |
				PHY_MASK0_RX_SENSE_1_MASK |
				PHY_MASK0_RX_SENSE_2_MASK |
				PHY_MASK0_RX_SENSE_3_MASK);
	_data_enable_polarity(index, 1);
	_interface_control(index, 0);
	_enable_tmds(index, 0);
	_power_down(index, 0);	/* disable PHY */
	phy_i2c_mask_interrupts(index, 0);

	// Clean IH_I2CMPHY_STAT0
	ddk770_HDMI_write_mask(index, IH_I2CMPHY_STAT0, IH_I2CMPHY_STAT0_I2CMPHYERROR_MASK | IH_I2CMPHY_STAT0_I2CMPHYDONE_MASK, 0);


	
	return 0;
}


__attribute__((unused)) static int hdmi_phy_configure_supported(hdmi_index index, u32 pClk, color_depth_t color,
		pixel_repetition_t pixel)
{
	int i   = 0;

	// Color resolution 0 is 8 bit color depth
	if (color == 0)
		color = COLOR_DEPTH_8;

	pClk = phy_get_freq(pClk);

	for (i = 0; phy311[i].clock != 0; i++ ){
		if(u32_is_equal(pClk, phy311[i].clock) &&
				(color == phy311[i].color) &&
				(pixel == phy311[i].pixel)){
			return 1;
		}
	}

	return 0;
}

static struct phy_config * hdmi_phy_get_configs(u32 pClk, color_depth_t color,
		pixel_repetition_t pixel)
{

	int i = 0;
	pClk = phy_get_freq(pClk);

	if(pClk == 1000)
		return NULL;
	for (i = 0; phy311[i].clock != 0; i++ ){

		if(u32_is_equal(pClk, phy311[i].clock) &&
				(color == phy311[i].color) &&
				(pixel == phy311[i].pixel)){
			return &(phy311[i]);
		}
	}
	return NULL;
	
}

static void mc_phy_reset(hdmi_index index, u8 bit)
{

	/* active high for (gen2) */
	/* active low  for (thrd_party ack) */
	ddk770_HDMI_write_mask(index, MC_PHYRSTZ, MC_PHYRSTZ_PHYRSTZ_MASK, bit);
}

static int phy_phase_lock_loop_state(hdmi_index index)
{
	
	return ddk770_HDMI_read_mask(index, (PHY_STAT0), PHY_STAT0_TX_PHY_LOCK_MASK);
}


static int phy_reconfigure_interface(hdmi_index index)
{

	ddk770_HDMI_Write_Register(index, JTAG_PHY_CONFIG, JTAG_PHY_CONFIG_I2C_JTAGZ_MASK);
	ddk770_HDMI_phy_i2c_slave_address(index,PHY_I2C_SLAVE_ADDR);

	return 0;

}

static int hdmi_phy_configure(hdmi_index index, u32 pClk, color_depth_t color, pixel_repetition_t pixel)
{
	int i   = 0;
	u16 phyRead = 0;
	u8 lock = 0;
	struct phy_config * config = NULL;
	u32 value = 0;

	// Color resolution 0 is 8 bit color depth
	if (color == 0)
		color = COLOR_DEPTH_8;

	config = hdmi_phy_get_configs(pClk, color, pixel);

	if (config == NULL) {
		printk("Configuration for clk %d color depth %d"
				  " pixel repetition %d not found", pClk, color, pixel);
		return -1;
	}

	// 0x40=24bit/pixel & no repetition
	ddk770_HDMI_Write_Register(index, 0x801, 0x40);

	// Set PHYTXCONFIG txphy_hdmi_i2c_jtagz=1(I2C)
#if 0
	value = dev_read(dev, 0xb0020);
	value |= (1 << 9);
	dev_write(dev, 0xb0020, value);
#else
	value = ddk770_HDMI_Read_Register(index, 0x3034 /*jtag_phy_conf*/);  
	value |= (1 << 4);												
	ddk770_HDMI_Write_Register(index, 0x3034, value);
#endif

	mc_phy_reset(index, 1);  //GEN2 highHDMI Source PHY active low reset control for PHY GEN1, active high reset control for PHY GEN2  ?

	ddk770_HDMI_write_mask(index, PHY_CONF0, PHY_CONF0_TXPWRON_MASK, 0);
	ddk770_HDMI_write_mask(index, PHY_CONF0, PHY_CONF0_PDDQ_MASK, 1);
	ddk770_HDMI_write_mask(index, PHY_CONF0, PHY_CONF0_SVSRET_MASK, 1);   // 3000  0b00110xxx

	mc_phy_reset(index, 0);

	phy_reconfigure_interface(index);    //slave addr 0x69 

	ddk770_HDMI_phy_i2c_write(index, OPMODE_PLLCFG, config->oppllcfg);
	if(ddk770_HDMI_phy_i2c_read(index, OPMODE_PLLCFG, &phyRead) || (phyRead != config->oppllcfg))
		printk("OPMODE_PLLCFG Mismatch Write 0x%04x Read 0x%04x\n",
				config->oppllcfg , phyRead);

	ddk770_HDMI_phy_i2c_write(index, PLLCURRCTRL, config->pllcurrctrl);
	if(ddk770_HDMI_phy_i2c_read(index, PLLCURRCTRL, &phyRead) || (phyRead != config->pllcurrctrl))
		printk("PLLCURRCTRL Mismatch Write 0x%04x Read 0x%04x",
				config->pllcurrctrl , phyRead);

	ddk770_HDMI_phy_i2c_write(index, PLLGMPCTRL, config->pllgmpctrl);
	if(ddk770_HDMI_phy_i2c_read(index, PLLGMPCTRL, &phyRead) || (phyRead != config->pllgmpctrl))
		printk("PLLGMPCTRL Mismatch Write 0x%04x Read 0x%04x\n",
				config->pllgmpctrl , phyRead);

	ddk770_HDMI_phy_i2c_write(index, TXTERM, config->txterm);
	if(ddk770_HDMI_phy_i2c_read(index, TXTERM, &phyRead) || (phyRead != config->txterm))
		printk("TXTERM Mismatch Write 0x%04x Read 0x%04x\n",
				config->txterm , phyRead);

	ddk770_HDMI_phy_i2c_write(index, VLEVCTRL, config->vlevctrl);
	if(ddk770_HDMI_phy_i2c_read(index, VLEVCTRL, &phyRead) || (phyRead != config->vlevctrl))
		printk("VLEVCTRL Mismatch Write 0x%04x Read 0x%04x\n",
				config->vlevctrl , phyRead);

	ddk770_HDMI_phy_i2c_write(index, CKSYMTXCTRL, config->cksymtxctrl);
	if(ddk770_HDMI_phy_i2c_read(index, CKSYMTXCTRL, &phyRead) || (phyRead != config->cksymtxctrl))
		printk("CKSYMTXCTRL Mismatch Write 0x%04x Read 0x%04x\n",
				config->cksymtxctrl , phyRead);

	ddk770_HDMI_write_mask(index, PHY_CONF0, PHY_CONF0_PDDQ_MASK, 0);
	ddk770_HDMI_write_mask(index, PHY_CONF0, PHY_CONF0_TXPWRON_MASK, 1);

	/* wait PHY_TIMEOUT no of cycles at most for the PLL lock signal to raise ~around 20us max */
	for (i = 0; i < PHY_TIMEOUT; i++) {
		lock = phy_phase_lock_loop_state(index);
		if (lock & 0x1) {
			printk("HDMI %d PHY PLL locked\n",index);
			return 0;
		}
		usleep_range(1000, 2000);
	}


	printk("PHY PLL not locked\n");
	return -1;
}

int ddk770_HDMI_PHY_Set_Mode(hdmi_index index, u32 pClk)
{
	int ret = 0;
	ret = hdmi_phy_configure(index,pClk,0,0);

	return ret;

}


