CREATE TABLE IF NOT EXISTS link_colors (
    id serial PRIMARY KEY,
    rstp_color varchar(10) DEFAULT '#FF000000',
    turbo_ring_color varchar(10) DEFAULT '#FF000000',
    turbo_ring_v2_color varchar(10) DEFAULT '#FF000000',
    turbo_chain_color varchar(10) DEFAULT '#FF000000',
    hsr_color varchar(10) DEFAULT '#FF800080',
    prp_lan_a_color varchar(10) DEFAULT '#FF0000FF',
    prp_lan_b_color varchar(10) DEFAULT '#FF008000',
    poe_color varchar(10) DEFAULT '#FF000000',
    link_up_color varchar(10) DEFAULT '#FF000000',
    link_down_color varchar(10) DEFAULT '#FFFF0000'
);

INSERT INTO link_colors (id) VALUES (1);

ALTER TABLE settings
    ADD IF NOT EXISTS link_colors_id serial NOT NULL REFERENCES link_colors (id);

ALTER TABLE settings
    ADD IF NOT EXISTS topology_style int NOT NULL DEFAULT 0;

ALTER TABLE settings
    ADD IF NOT EXISTS show_poe boolean NOT NULL DEFAULT true;

CREATE SCHEMA IF NOT EXISTS grid;

CREATE TABLE IF NOT EXISTS grid.grid_settings (
    onerow_id bool PRIMARY KEY DEFAULT TRUE,
    prp_lan_a_flag boolean NOT NULL DEFAULT TRUE,
    prp_lan_b_flag boolean NOT NULL DEFAULT TRUE,
    hsr_flag boolean NOT NULL DEFAULT TRUE
);
INSERT INTO grid.grid_settings (onerow_id) VALUES (true);

ALTER TABLE links
    ADD IF NOT EXISTS redundancy int NOT NULL DEFAULT 0;