CREATE TABLE
    IF NOT EXISTS public.serial_port_monitoring_settings (
        ip VARCHAR(16),
        port_id INT,
        check_duration_rx INT,
        check_duration_tx INT,
        check_duration_rx_tx INT,
        severity_rx INT,
        severity_tx INT,
        severity_rx_tx INT,
        severity_error_count_frame INT,
        severity_error_count_parity INT,
        severity_error_count_overrun INT,
        severity_error_count_break INT,
        threshold_error_count_frame INT,
        threshold_error_count_parity INT,
        threshold_error_count_overrun INT,
        threshold_error_count_break INT,
        id serial PRIMARY KEY,
        created_at TIMESTAMP
        WITH
            TIME zone,
            updated_at TIMESTAMP
        WITH
            TIME zone,
            deleted_at TIMESTAMP
        WITH
            TIME zone,
            UNIQUE (ip, port_id) -- 這裡添加了唯一約束
    );

CREATE INDEX IF NOT EXISTS idx_serial_port_monitoring_ip_port_id ON public.serial_port_monitoring_settings (ip, port_id);

CREATE INDEX IF NOT EXISTS idx_serial_port_monitoring_ip ON public.serial_port_monitoring_settings (ip);
