from os import listdir
import re

files = listdir("migrations/db")
migration_dict = {}
for filename in files:
    p = re.compile(r'(00[^_]*).*\.up\.sql')
    match = p.match(filename)
    if match is None:
        continue
    index = match.group(1)
    if index in migration_dict:
        raise Exception('duplicated migrations') 
    else:
        migration_dict[index] = True

print('pass migration check')