﻿using CommandLine;
using CommandLine.Text;
using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;

namespace mx_led_ctl
{
    class Program
    {
        class Options
        {
            [Option('i', Required =true, HelpText = "-i <#LED index> (Start from 0)")]
            public uint LEDIndex { get; set; }

            [Option('m', Default = null,
                HelpText = "-m <status>\n" +
                " 		0 --> led off\n" +
                "		1 --> led on\n" +
                "		2 --> led blink"
                )]
            public int? Mode { get; set; }

            [Usage(ApplicationAlias = "mx-led-ctl")]
            public static IEnumerable<Example> Examples
            {
                get
                {
                    yield return new Example("Get value from LED index 1", new Options { LEDIndex = 1 });
                    yield return new Example("Turn on LED index 2", new Options { LEDIndex = 2, Mode = 1 });
                    yield return new Example("Set LED index 3 to blink mode", new Options { LEDIndex = 3, Mode = 2 });
                }
            }
        }

        [DllImport("mxled.dll", EntryPoint = "GetLedData", CharSet = CharSet.Ansi, SetLastError = true)]
        public static extern int GetLedData(int port);

        [DllImport("mxled.dll", EntryPoint = "SetLedData", CharSet = CharSet.Ansi, SetLastError = true)]
        public static extern int SetLedData(int port, int mode);

        public struct Action_Struct
        {            
            public int index;
            public int mode;
        };

        static void Main(string[] args)
        {
            CommandLine.Parser.Default.ParseArguments<Options>(args)
                .WithParsed(opts =>
                {
                    if (opts.Mode == null)
                    {
                        GetModeAction(opts);
                    }
                    else
                    {
                        SetModeAction(opts);
                    }
                });
        }

        private static void SetModeAction(Options opts)
        {
            Action_Struct action;
            action.index = (int)opts.LEDIndex;
            if (SetLedData(action.index, (int)opts.Mode) < 0)
            {
                Console.WriteLine("Failed to set LED index {0} value.", action.index);
            }
            else
            {
                action.mode = GetLedData(action.index);
                if (action.mode >= 0)
                {
                    Console.WriteLine("LED index {0} data: {1}", action.index, action.mode);
                }
            }
        }

        private static void GetModeAction(Options opts)
        {
            Action_Struct action;
            action.index = (int)opts.LEDIndex;
            action.mode = GetLedData(action.index);
            if (action.mode >= 0)
            {
                Console.WriteLine(string.Format("LED index {0} data: {1}", action.index, action.mode));
            }
        }
    }
}
