Intel(R) Ethernet Flash Firmware Utility
========================================
October 23, 2020

CONTENTS
========
- DISCLAIMER
- INTRODUCTION
- RUNNING BootUtil
- COMMAND LINE OPTIONS
- EXAMPLES
- EXIT CODES


DISCLAIMER
==========
This README.TXT, as well as the software described in it, is furnished under
license and may only be used or copied in accordance with the terms of the
license. The information in this manual is furnished for informational
use only, is subject to change without notice, and should not be construed
as a commitment by Intel Corporation. Intel Corporation assumes no
responsibility or liability for any errors or inaccuracies that may appear
in this document or any software that may be provided in association with
this document.

Except as permitted by such license, no part of this document may be
reproduced, stored in a retrieval system, or transmitted in any form or
by any means without the express written consent of Intel Corporation.


INTRODUCTION
============
The Intel(R) Ethernet Flash Firmware Utility (BootUtil) is used to update
configurations and program the PCI option ROM on the flash memory of supported
Intel PCI and PCI-Express-based network adapters.
BootUtil replaces existing utilities and provides the functionality of the
older IBAUTIL, LANUTIL, and FLAUTIL. BootUtil supports all the adapters
supported by the previous utilities.

NOTES:
- Legacy iSCSI Boot and CLP images are not supported and cannot be loaded or
configured.
- Updating the adapter's flash memory using BootUtil will erase any existing
firmware image from the flash memory.
- If your device is flashed with a discrete FCoE firmware (no other Option ROMs
flashed), attempts to update your device will fail. This is expected. The data
required for FCoE functionality upgrades is no longer part of the latest
upgrade packages. The update will fail and FCoE functionality will continue to
work.
- If you update a device that is flashed with an FCoE-enabled combo image (for
example, an image that contains the EFI driver, legacy PXE, and FCoE boot
functionality), the Option ROM combination will change on update, usually to
the same combination without FCoE capabilities. This is expected. The data
required for FCoE functionality upgrades is no longer part of the latest
upgrade packages. The update will succeed and FCoE functionality will be
removed from your device.

Intel provides the following flash firmware in FLB file format for programming
to the flash memory:

- Intel(R) Boot Agent as PXE Option ROM for legacy BIOS
  http://www.intel.com/support/network/adapter/pro100/bootagent/
- Network Connectivity, UEFI network driver
  http://www.intel.com/support/network/sb/cs-006120.htm

OEMs may provide custom flash firmware images for OEM network adapters. Please
refer to the instructions given by OEMs.

BootUtil allows the user to flash supported firmware to the adapter from the
included BootIMG.FLB file. This option ROM includes PXE and UEFI, and the image
is programmed to the flash memory at once. BootUtil will also build the
required combo images for supported adapter and program those images to the
flash, as well. Since both discrete and combo images are supported, the
-BOOTENABLE command ONLY works on combo images.

PXE+EFI image combinations are supported for all OEM generic adapters, however
support is limited to devices which support both technologies as discrete
images. However, flash size is a limiting factor, as the image size can change
without notice.

The BOOTIMG.FLB file is the container for all the Intel(R) boot Option ROMs.
This file replaces the existing FLB files for PXE and EFI.

BootUtil without command-line options will display a list of all supported
Intel network ports in the system. BootUtil will also allow the user to enable
or disable the flash memory on specific ports by using -FLASHENABLE or
-FLASHDISABLE options in order to control access to the firmware from the
system.

BootUtil allows the user to individually set UEFI and  PXE boot configurations
by -NIC=xx -<OPTION>=<VALUE> options.

NOTES:
* BootUtil displays up to 128 adapter ports.
* No configuration settings are supported for the UEFI driver.
* -NIC, -MACADDR, and -DEVID are mutually exclusive. You cannot use more than
one of these options per command. Specifying more than one option will cause
BootUtil to fail.
* You cannot enable/disable 64-bit BAR addressing on Intel(R) Ethernet
Controller X550 Series devices.
* BootUtil may indicate that a device is in the "Pending Reboot" state. No
update or configuration changes are possible on a device in this state. Please
reboot your system.

Check the Intel Customer Support (http://support.intel.com) website for the
latest information and component updates.

NOTE: If the tool displays the error: "Unable to load the driver. Please close
all other applications and try again", you have a mix of old and new versions
of the utility tool on your system. Quit all open applications and retry your
operation. If the issue persists:
1. Download the latest version of the utility tools.
2. Run the uninstall script to remove the old version of the tool driver.
3. Run the install script from the downloaded tools package.
4. Retry your operation.
You may also need to download and install the latest Intel Ethernet driver or
Intel PROSet package for your device.


RUNNING THE UTILITY
===================
Using the "/?" option will display a list of supported command line options.
The syntax for issuing BootUtil command-line options is:
BOOTUTIL -[OPTION] or -<OPTION>=<VALUE>


COMMAND LINE OPTIONS
====================
BootUtil accepts one executable option and its associated non-executable
options in an execution. If conflicting executable options are specified,
BootUtil exits with an error.

The options, where applicable, are listed in logical groups.

NOTE: If you run BootUtil without any command-line options, the utility
displays a list of all supported Intel network ports found in the system.


GENERAL OPTIONS:
-? or -HELP
Displays a list of command-line options.
-ALL
Selects all supported network ports found in the system.

-64d
Disables 64-bit BAR (Base Address Register) addressing on the selected port.
This restricts the system BIOS to assigning 32-bit BARs to the port.

-64e
Enables 64-bit BAR addressing on the selected port.

-BLINK
Blinks the LED on the selected port for ten seconds.

-DEVID=[Device ID]
Selects the network port specified by [Device ID]. [Device ID] is a 4 digit
hexadecimal number, prepended by 0x.

-EXITCODES
Displays exit codes returned to the OS environment by BootUtil.

-E
Enumerates all supported network ports in the system.

-FILE=[FILENAME]
Specifies the file name for -SAVEIMAGE, -RESTOREIMAGE, -SAVECONFIG,
-RESTORECONFIG, -UP or -UPDATE options.

-IMAGEVERSION or -IV
Displays the firmware image type and version number from the specified source.
If no source is specified, displays the image type and version number from the
local BootIMG.FLB file. Use -FILE to specify a different file. Use -NIC to
specify a port. Use -ALL to display the firmware image types and version
numbers of images loaded onto all ports in the system. If a port does not have
an image loaded, or is not an Intel Ethernet port, the port will not be
included in the -ALL output.

-MACADDR=[MAC address string]
Selects the network port specified by [MAC address string]. [MAC address
string] is a 12 digit number. Separators (":" or "-") are allowed but not
required.

-NIC=XX
Selects a specific network port in the system.

-NODPL
With command, BootUtil does not display the PCI device location.

-O=[FILENAME]
Must be used with -E . Saves a list of all NICs and their MAC addresses to the
specified file.

-P
With this command, BootUtil pauses screen after displaying every 25th line. In
pause mode, last line of the screen will contain information that:
  - screen has been paused, and
  - user can press Enter to continue


POWER MANAGEMENT OPTIONS:

-WOLENABLE or -WOLE
Enables Wake On LAN (WOL) functionality on the selected port.

-WOLDISABLE or -WOLD
Disables Wake On LAN (WOL) functionality on the selected port.


ADAPTER FLASH ENABLE/DISABLE OPTIONS:

-BOOTENABLE=[PXE or DISABLED]
Selects flash firmware type to enable or disable on the selected port. The
combo option ROM could have all capabilities. This command will NOT WORK on
monolithic Option ROMs.

NOTE: This manual command is not applicable to the UEFI network driver. The
UEFI network driver is enabled by default and loaded automatically unless
network ports are already used by other flash firmware.

  BOOTENABLE=DISABLED
  Disables PXE functionalities for legacy BIOS.

-FLASHENABLE or -FE
Enables the capability to run flash firmware on the selected adapter.

NOTE: This parameter is not supported on the following adapters:
  - Intel(R) Gigabit ET Quad Port Mezzanine Card
  - Intel(R) Ethernet X520 10GbE Dual Port KX4 Mezz
  - Intel(R) Ethernet X520 10GbE Dual Port KX4-KR Mezz

-FLASHDISABLE or -FD
Disables the capability to run flash firmware on the selected adapter.

NOTE: This parameter is not supported on the following adapters:
  - Intel(R) Gigabit ET Quad Port Mezzanine Card
  - Intel(R) Ethernet X520 10GbE Dual Port KX4 Mezz
  - Intel(R) Ethernet X520 10GbE Dual Port KX4-KR Mezz


FLASH PROGRAMMING OPTIONS:

-QUIET
Runs BootUtil without confirmation prompts. This option is used with
-IMAGEVERSION, -UP, -UPDATE, -RESTOREIMAGE, or -HELP option.

-RESTOREIMAGE or RI
Restores a previously-saved firmware image to the same network adapter using
the -NIC option. The source file is specified by the -FILE option.

-SAVEIMAGE or SI
Saves the existing firmware image in the flash memory of the adapter specified
by the -NIC option to a disk file. The destination file is specified by the
-FILE option.

-UP or -UPDATE=[ROMType] [-FILE=Filename]
Updates the flash memory of the adapter specified by the -NIC option with the
given FLB flash firmware image file. If -QUIET is not specified, the user is
prompted to confirm overwriting the existing firmware image before upgrading.
If a Filename is not provided, the utility looks for the default <bootimg.FLB>
file which contains all image types.

The following examples use PXE, but could also be efi or efi64.
  Bootutil -Nic=x -up=pxe
  Bootutil -Nic=x -up=pxe -file=pxeimg.flb

If your adapter supports a combo option rom, the following command option
automatically detects the supported combo image and programs the adapter with
that image.
  -up=combo
    up=pxe+efi is valid.


PXE BOOT CONFIGURATION OPTIONS: (Can be used with -NIC or -ALL)

-DEFAULTCONFIG or -DEFCFG
Sets the PXE configuration of the selected NIC back to default settings.

-MODE
This parameter should not be used except as advised by Intel Support personnel.

-TITLEENABLE OR -TLE
Enables Initial Title Message.

-TITLEDISABLE OR -TLD
Disables Initial Title Message.


EXAMPLES
========
The following examples show how to enter some typical BootUtil command lines:

Example: To enable the flash firmware on the first network adapter for the
system to be capable of executing the flash firmware.
  BootUtil -NIC=1 -FLASHENABLE

Example: To disable the flash firmware on all the network adapters.
  BootUtil -ALL -FD

Example: To display BootUtil FLB flash firmware types and versions.
  BootUtil -IMAGEVERSION

Example: To update all ports of a supported NIC with PXE.
  1. BootUtil -UP=PXE -ALL (Assumes input file is bootimg.flb)
  2. BootUtil -UP=PXE -ALL -FILE=BOOTIMG.FLB (explicit user specified file)

Example: To update a combo image on supported adapter (eg, pxe+efi)
  1. BootUtil -UP=Combo -NIC=2 -FILE=BOOTIMG.FLB

The above command will succeed if the PXE+EFI combination is supported on NIC
#2. If not an error is displayed to the user.

NOTE: THE -UP and -UPDATE commands are equivalent and interchangeable.

Example: To enable PXE firmware on the third network port in the system.
  BootUtil -BOOTENABLE=PXE -NIC=3

NOTE: This command will work only if PXE is part of a combo Option ROM and not
a discrete Option ROM.

Example: To disable the firmware on the second network port in the system.
  BootUtil -NIC=2 -BOOTENABLE=DISABLED

Example: To get help descriptions.
  BootUtil -?


EXIT CODES
==========
BootUtil returns an exit code to the OS environment. Possible exit codes are
listed below:
Code Name                                      Value
----------------------------------------------+-----
All BootUtil operations completed successfully   0
Bad command-line parameter                       1
No supported network port detected               2
Invalid network port selected                    3
FLASH operation failed                           4
EEPROM read operation failed                     5
EEPROM write operation failed                    6
File content is missing or corrupt               7
Operator termination                             8
LOM not supported for selected operation         9
Network port is not bootable                    10
FLASH memory is disabled for flash firmware     11
FLASH memory too small for selected firmware    12
System memory allocation failed                 14
File operation failed                           15


Copyright(c) 2015 Intel Corporation.
Installation
=============

INSTALLING THE TOOLS ON MICROSOFT WINDOWS(R)
============================================

The tools driver can be installed on all versions of Windows since Windows 2000.
The tools driver for the 32-bit versions of Windows are in the
Win32 directory on the CD.  The tools driver for the 64-bit versions of Windows
are in the Win64 (Itanium) or Win64e (x64) directory on the CD.

To install the tools' drivers on Windows, run install.bat from the appropriate
directory on the CD.

Although the tools are not installed with install.bat, the driver that
the tools require is copied into the local machine Windows driver directory.
To run the tools, launch a Command Prompt window from the Windows Start Menu.
Go to the media and directory where the tools are located and run the tools.
The readme files for each tool are found in the same directory as the tools.
These tools can be manually installed on the local hard drive in any directory.

The tool uses its own driver file (not the same as the system network driver).
If the driver sys file already exists in the drivers directory, install.bat may
fail to copy. The /y switch to install.bat will override and copy the driver file
regardless. However, this can be dangerous if an older version of the driver is
being used by another application such as PROset for Device Manager. If a driver
is already present in the drivers directory, try running the tool from the command
prompt. If it runs, then the driver is fine. The tool will not run if the driver
version present does not match the driver version expected.

Note that for Windows Vista, the user must have access to the
%systemroot%\system32\drivers directory. Only the administrator account has these
privileges. The user must be logged in as administrator or "run as" administrator
all tools on this OS.

Note that on Windows, any device that is disabled in device manager will not be
accessible by tools due to no memory resources. You would get an error code 0xC86A800E.
To solve this problem, you can do one of the following:
1) Re-enable the device in device manager. Never disable this device when using tools.
2) Install an NDIS device driver for the device and make sure that it does not have
   a yellow or red bang by it in device manager.
3) Delete the device from device manager and restart the system. The install new
   hardware wizard should appear on next reboot. Do not cancel this. Just move the
   window aside and run the tool(s). Generally, you can click "cancel" on the wizard
   but there are some cases where Windows will disable the memory resources causing
   you to get back into the same state.

INSTALLING THE TOOLS ON EFI
==============================

The tools support Intel EFI v1.10 for EFI32 (x86), EFI64E (x64), and EFI64 (Itanium).
The tools for EFI directory on the CD and can be differentiated by the 32, 64, or 64E in
the tools' filenames.  There is no installation required for EFI tools.
The tools can simply be copied to the drive that they will run from.

Note that while EFI supports USB drives, there may be issues running tools from the USB
drive. Whether or not there are issues are BIOS specific. If issues are experienced,
the tool should be run from hard disk instead.


INSTALLING THE TOOLS ON DOS
===========================

The tools support various DOS versions from Windows XP DOS (reached by creating
a DOS boot disk in the explorer GUI) to FreeDOS.  There is no installation required for
DOS tools. The tools can simply be copied from the DOS directory on the CD to the drive
that they will run from.  It is expected that the tools have a clean boot environment.
The tools will not run with memory managers and/or DOS networking drivers loaded.
The tools expect that they have full, unlimited control of the hardware. The tools
*WILL NOT* run properly if EMM386 is present.  The tools run in protected mode, 32-bit
DOS. Therefore, they will not be compatible with any TSR programs.


INSTALLING THE TOOLS ON LINUX
==============================

In order to run tools on Linux, a driver stub must be built and installed on the system.
This driver is not related to the network device driver that is used to run the network
during live traffic. It is a separate driver used explicitly for tools. Due to the
nature of Linux with the number of kernels that can exist, we provide source for the
driver module and an install script to build/install it.

The tools support Linux distributions based on kernels 2.6.x. Validation is
done randomly on popular distributions such as Fedora, Suse, or Ubuntu. Configured kernel source
that matches the currently installed kernel is required. A working GCC is also required.
There are some versions of GCC that had a bug which did not support unnamed structures.
These versions of GCC are not supported. If you have compilation errors, try updating
your version of GCC.  If you have linker errors when installing the driver, you should
update your kernel - download the latest stable off www.kernel.org and build/install it.

Note that some distributions such as recent Fedora core versions do not ship with Kernel
source. You must download, install, and configure the source in order to get the tools'
driver built on this OS. Installing the kernel source RPM does not solve the problem.

This is the installation procedure for the TAR.GZ package:

    1. Log in as root and create a temporary directory to build the Intel(R)
       Network Connection Tools driver.

    2. Copy 'install' and 'iqvlinux.tar.gz' to the temporary directory.
       There are 3 versions of Linux supported: Linux32 (x86), Linux64e (x64),
       and Linux64 (Itanium). Copies of the above files exist in the appropriate
       directory for your platform.

    3. CD to the temporary directory and run './install.'  The driver has been
       installed now, so the files in the temporary directory can be removed.

    4. Copy the tools that you want to use from the appropriate directory of the CD.

This is the installation procedure for the RPM package:

    1. Log in as root.

    2. Copy RPM package (iqvlinux-<version>.noarch.rpm) to the home directory.

    3. CD to the home directory and run command:
       rpm -i iqvlinux-<version>.noarch.rpm

    4. Copy the tools that you want to use from the appropriate directory of the CD.


DRIVERLESS MODE
===============
On Linux OS it is possible to operate in driverless mode. This mode doesn't
require to install any driver neither QV driver nor base driver. To obtain needed
data the sysfs virtual file system and mmap functionality (mapping kernel resources
to user space) is used. Note that in some cases Linux kernel is preventing from
mapping required memory if it is mapped by another program (for example base driver).
It requires a reboot with kernel boot parameter set to 'iomem=relaxed' or unload
base driver.
Driverless mode supports only reduced set of diagnostics (FIFO test, Registers
test and EEPROM test) and fully access to CSR, EEPROM and FLASH resources.


CUSTOMER SUPPORT
================

- Main Intel web support site: http://support.intel.com

- Network products information: http://www.intel.com/network

- Worldwide access: Intel has technical support centers worldwide.  Many
  of the centers are staffed by technicians who speak the local languages.
  For a list of all Intel support centers, the telephone numbers, and the
  times they are open, visit http://www.intel.com/support/9089.htm.

- Telephone support: US and Canada: 1-916-377-7000
  (7:00 - 17:00 M-F Pacific Time)


Legal / Disclaimers
===================

Copyright (C) 2002, Intel Corporation.  All rights reserved.

Intel Corporation assumes no responsibility for errors or omissions in this
document.  Nor does Intel make any commitment to update the information
contained herein.

* Other product and corporate names may be trademarks of other companies and
are used only for explanation and to the owners' benefit, without intent to
infringe.

* Internal Version *
