# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [1.3] - 2025-09-18
### Added
* Add new features:
  - Add flow to support files install, uninstall, self-test, and dry-run
  - Add flow to support packages install, uninstall, self-test, and dry-run
  - Add verbose option to show files and packages information on install, uninstall, self-test, and dry-run
  - Add daughter-board detection utility to get board index from EEPROM
  - Add system diagnostic tool
  - Add errata format and files
  - Support text-based user interfaces for custom config
  - Auto generate changelog from product dry-run lists
* Support new models:
  - DA-920E
  - V2202D
* Add source list:
  - Tools:
    - 'moxa-x86-control-tools' version 2.19.0, 2.20.0 and 2.21.0
  - Driver:
    - 'moxa-mxuport-driver' version 5.2.21_build_25091214 and 6.1.7_build_25090915
    - 'siliconmotion-smifb-driver' version 4.5.0+1.0.0
    - 'moxa-it87-gpio-driver' version 5.2+1.6.0
    - 'moxa-it87-wdt-driver' version 5.2+1.7.0
    - 'moxa-it87-serial-driver' version 1.5.0
    - 'moxa-it87-driver' version 6.6+moxa2
* Update modules.dep information in the end of postinst.sh
* Compress kernel module by CONFIG_MODULE_COMPRESS_* type

### Changed
* Revision to two-part format (major.minor) 1.3
* Update product driver and tool to latest version:
  - BXP-A100
  - BXP-C100
  - RKP-A110
  - RKP-C110
  - DRP-A100
  - DRP-C100
  - MPC-3000
* Improve self-test result
  - libgpiod
  - moxa-mcu-manager
* Install watchdog package on Rocky Linux 9
* Install moxa-x86-control-tools corresponding to the product daughter board
* Show product name instead of hardware board ID
* Rename this file to CHANGELOG.md
* Refactor for new build mechanism:
  - Remove category-version config build
  - Remove soruce version compare function

### Removed
* Deprecated MCM download list which has been replaced by packages list
* Deprecated build source list and log deu to redundant information
* Remove the 'Standard V1.0 to V1.3' config folders due to new build mechanism
