# Errata Files Description
## Severity

Minor (Critical/High/Medium/Low/Minor)

## Products Affected

- NA

## Description

```
This document records product errata (imitations, bugs, CVEs, and similar issues) in Markdown (.md) format.
The format of document is described in detail below:

* The document name should be 4 digits + Title (e.g. 0001-pca953x-driver-version-5.10+1.0.0-Does-Not-Support-Red-Hat-9.5.md)
* The document format is Markdown (.md), with the following chapter headings:
# Title
## Severity
## Products Affected
## Description
## Implications
## Workaround
* In Products Affected, use a hierarchical bullet list to indicate the impacted configurations (product + distribution + kernel version).
  If necessary, use comparison operators to describe version constraints (e.g., Kernel >= 6.0, Kernel < 5.10).
Example 1：
- BXP-C100 
    - Debian 10
        - kernel 4.19
Example 2：
- CentOS 7.9
Example 3：
- kernel 4.19
Example 4：
- DA-820C
    - Ubuntu 22.04
        - kernel <= 5.19
Example 5：
- BXP-C100
    - Kernel > 5.4
* If any errata are added, removed, or their content is changed, you may briefly record these updates in the CHANGELOG.
```

## Implications

NA

## Workaround

NA
