#!/bin/bash
#
# Copyright (C) 2023 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#
# Authors:
#       2023  Wilson YS Huang  <wilsonys.huang@moxa.com>

source "${INSTL_SCRIPT_DIR}/lib/util.sh"
source "${INSTL_SCRIPT_DIR}/lib/logger.sh"
source "${INSTL_SCRIPT_DIR}/lib/driver.sh"
log::init "${INSTL_LOG_FILE}" "${INSTL_LOG_LEVEL}"

set -e

REPO_NAME="moxa-it87-gpio-driver"
SRC_PATH_PREFIX="${INSTL_TOP_DIR}/src/${REPO_NAME}"

main() {
        local src_tag
        local src_ver
        src_tag="$1"
        src_ver="$2"

        log::info "Installing ${REPO_NAME} (${src_ver})"

        {
                # Encounter error log: Could not insert 'gpio_it87': Device or resource busy
                if [[ "${LINUX_DISTRO_ID}" == "centos" ]]; then
                        if ! grep -wq "acpi_enforce_resources" "/etc/default/grub"; then
                                sed -i "s/GRUB_CMDLINE_LINUX=\"[^\"]*/& acpi_enforce_resources=lax/" /etc/default/grub
                                grub2-mkconfig -o /etc/grub2.cfg
                                grub2-mkconfig -o /etc/grub2-efi.cfg
                        fi
                fi

                pushd "${SRC_PATH_PREFIX}-${src_tag}" >/dev/null

                make clean
                make install

                # Compress module if kernel config compress type is enabled
                drv_path=$(modinfo -n gpio_it87 2>/dev/null || true)
                drv::compress_module "$drv_path"

                make load

                popd
        } >>"${INSTL_LOG_FILE}" 2>&1
}

main "$@"
