#!/bin/bash
#
# Copyright (C) 2023 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#
# Authors:
#       2023  Wilson YS Huang  <wilsonys.huang@moxa.com>

source "${INSTL_SCRIPT_DIR}/lib/util.sh"
source "${INSTL_SCRIPT_DIR}/lib/logger.sh"
log::init "${INSTL_LOG_FILE}" "${INSTL_LOG_LEVEL}"

set -e

REPO_NAME="moxa-hid-ft260-driver"
SRC_PATH_PREFIX="${INSTL_TOP_DIR}/src/${REPO_NAME}"

main() {
        local src_ver
        src_tag="$1"
        src_ver="$2"

        log::info "Uninstall ${REPO_NAME} ($src_ver)"

        {
                pushd "${SRC_PATH_PREFIX}-${src_tag}" >/dev/null

                make clean
                make uninstall
                rm /etc/udev/rules.d/11-ft260-pca9535.rules

                popd
        } >>"${INSTL_LOG_FILE}" 2>&1

        if util::is_exists "/etc/udev/rules.d/11-ft260-pca9535.rules"; then
                log::debug "Remove 11-ft260-pca9535.rules"
                rm -f "/etc/udev/rules.d/11-ft260-pca9535.rules"
        fi
}

main "$@"
