#!/bin/bash
#
# Copyright (C) 2024 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#
# Authors:
#       2024  Wilson YS Huang  <wilsonys.huang@moxa.com>

source "${INSTL_SCRIPT_DIR}/lib/util.sh"
source "${INSTL_SCRIPT_DIR}/lib/logger.sh"
log::init "${INSTL_LOG_FILE}" "${INSTL_LOG_LEVEL}"

set -e

REPO_NAME="watchdog"

main() {
        local src_ver
        src_ver="$2"

        log::info "Uninstall ${REPO_NAME} ($src_ver)"

        if util::is_exists "/etc/watchdog.conf"; then
                log::debug "Remove 'watchdog-device' in '/etc/watchdog.conf'"
                sed -i "s/watchdog-device/#watchdog-device/g" /etc/watchdog.conf
        fi

        log::info " Disable Watchdog Service"
        systemctl disable watchdog.service
}

main "$@"
