#!/bin/bash

SYS_LOG_PATH=/var/log/mcm_adv_diag
MODULE_DIR="/lib/moxa/MoxaConnectionManager/adv_diag_module"
TARGET_IMEI=${1}
MODEM_ID=

_logger() {
    logger -t "CELLULAR" "${1}"
}

find_modem_id() {
    local target_imei=${TARGET_IMEI}
    local modem_index=
    local search_device=

    local modem_index_list

    modem_index_list=$(mmcli -L | cut -d '/' -f6 | cut -d ' ' -f 1 | tr '\n' ' ')

    if [ -z "${modem_index_list}" ]; then
        echo "Not found Modem on IMEI" "${target_imei}"
        exit 1
    fi

    for modem_index in ${modem_index_list}; do
        imei=$(mmcli -m "$modem_index" -K | grep "modem.generic.equipment-identifier")
        if [ -z "${imei}" ]; then
            echo "No fount Modem on IMEI" "${target_imei}"
            exit 1
        fi
        search_device=$(echo "${imei}" | grep "${target_imei}")
        if [ -n "${search_device}" ]; then
            MODEM_ID=$modem_index
            return
        fi
    done
}

start_logging() {
    _logger "======== ADV-DIAG Cellular Info Collection START ========"
    _logger "$(uname -a)"
    _logger "$(fw_printenv modelname)"
}

end_logging() {
    _logger "==== ADV-DIAGADV-DIAG Cellular Info Collection END ======"
    _logger " "
}

mmcli_at() {
    local at_op_cmd=
    local at_op_rsp=
    local at_cmd=${1}
    local timeout=${2}

    if [ -z "${timeout}" ]; then
        timeout=30
    fi

    at_op_cmd="mmcli -m ${MODEM_ID} --timeout=${timeout} --command=${at_cmd}"
    at_op_rsp=$($at_op_cmd 2>/tmp/error.log | sed s/response:[[:space:]]//g | tr -d \')

    if [ -z "$at_op_rsp" ] && [ -f "/tmp/error.log" ]; then
        at_op_rsp="$at_cmd: $(grep error </tmp/error.log)"
        rm /tmp/error.log
    fi
    _logger "$at_op_rsp"

    echo "$at_op_rsp"
}

mcm_adv_diag_cellular_vendor_info() {
    _logger "********************** VENDOR INFO **********************"
    local vendor
    local adv_diag_script_path

    vendor=$(mmcli_at "AT+CGMI")

    adv_diag_script_path=${MODULE_DIR}/${vendor}_adv_diag.sh
    eval "source ${adv_diag_script_path}"

    eval "mcm_adv_diag_${vendor,}_info"
}

mcm_adv_diag_cellular_device_info() {
    _logger "********************** MODULE INFO **********************"
    #Module model:
    mmcli_at "AT+CGMM"

    #Firmware version:
    mmcli_at "AT+CGMR"

    #IMEI Code:
    mmcli_at "AT+CGSN"

    #Set Mode of Operator for EPS
    mmcli_at "AT+CEMODE?"
    mmcli_at "AT+CPIN?"
}

mcm_adv_diag_cellular_modem_info() {
    _logger "******************** NETWORK INFO ***********************"
    #Operational mode:
    mmcli_at "AT+CFUN?"

    #Selected network access techniques:
    mmcli_at "AT+WS46?"

    #List network operator info:
    mmcli_at "AT+COPS?"

    #Signal strength:
    mmcli_at "AT+CSQ"

    #List APN details:
    mmcli_at "AT+CGDCONT?"

    #List Packet switch enable/disable status:
    mmcli_at "AT+CGATT?"

    #List PDP profiles status:
    mmcli_at "AT+CGACT?"

    #List bearers and IP addresses:
    mmcli_at "AT+CGCONTRDP="

    mmcli_at "AT+CGPADDR="

}

find_modem_id

#Without target imei not able to collect the correct info
if [ -z "$TARGET_IMEI" ] || [ -z "$MODEM_ID" ]; then
    exit 1
fi

mkdir -p $SYS_LOG_PATH

start_logging

mcm_adv_diag_cellular_device_info

mcm_adv_diag_cellular_modem_info

mcm_adv_diag_cellular_vendor_info

end_logging
