CREATE SCHEMA IF NOT EXISTS wireless;

ALTER TABLE IF EXISTS wireless_roles SET SCHEMA wireless;

ALTER TABLE IF EXISTS wireless_histories SET SCHEMA wireless;

CREATE TABLE IF NOT EXISTS wireless.wireless_settings (
    onerow_id bool PRIMARY KEY DEFAULT TRUE,
    reserved_safety_factor int NOT NULL,
    rx_sensitivity_low int NOT NULL,
    rx_sensitivity_medium int NOT NULL,
    rx_sensitivity_high int NOT NULL,
    CONSTRAINT onerow_uni CHECK (onerow_id)
);

CREATE TABLE IF NOT EXISTS wireless.wireless_device_settings (
    device_id int PRIMARY KEY REFERENCES devices (id) NOT NULL,
    tx_cable_loss int NOT NULL,
    rx_cable_loss int NOT NULL,
    tx_antenna_gain int NOT NULL,
    rx_antenna_gain int NOT NULL
);

