CREATE TABLE IF NOT EXISTS grid.ieds (
    ied_name varchar(64) PRIMARY KEY,
    device_id int,
    CONSTRAINT fk_device FOREIGN KEY (device_id) REFERENCES devices (id)
);

CREATE TABLE IF NOT EXISTS grid.gses (
    ied_name varchar(63) NOT NULL,
    cb_name varchar(63) NOT NULL,
    vlan_id int,
    mac varchar(31),
    app_id varchar(64),
    PRIMARY KEY (ied_name, cb_name),
    CONSTRAINT fk_ied FOREIGN KEY (ied_name) REFERENCES grid.ieds (ied_name)
);

CREATE TABLE IF NOT EXISTS grid.gse_controls (
    id serial PRIMARY KEY,
    ied_name varchar(63) NOT NULL,
    cb_name varchar(63) NOT NULL,
    dest varchar(63) REFERENCES grid.ieds (ied_name),
    FOREIGN KEY (ied_name, cb_name) REFERENCES grid.gses (ied_name, cb_name)
);

