CREATE TABLE IF NOT EXISTS virtual_topo.unmanaged_objects (
    id int UNIQUE NOT NULL DEFAULT nextval(pg_get_serial_sequence('nodes', 'id')),
    group_id int REFERENCES groups (id) NOT NULL,
    alias varchar(63),
    model varchar(63),
    icon_url varchar(63),
    location varchar(255),
    x int,
    y int,
    warning_source_ip inet,
    warning_description varchar(63),
    warning_recovery varchar(63),
    warning_fieldname varchar(63),
    warning_fieldindex int,
    warning_threshold_type int,
    warning_threshold varchar(63),
    warning_duration int,

    critical_source_ip inet,
    critical_description varchar(63),
    critical_recovery varchar(63),
    critical_fieldname varchar(63),
    critical_fieldindex int,
    critical_threshold_type int,
    critical_threshold varchar(63),
    critical_duration int
);

DROP TRIGGER IF EXISTS create_unmanaged_node_trigger ON virtual_topo.unmanaged_objects;
CREATE TRIGGER create_unmanaged_node_trigger
    BEFORE INSERT ON virtual_topo.unmanaged_objects
    FOR EACH ROW
    EXECUTE PROCEDURE create_corresponding_node ('unmanaged');

DROP TRIGGER IF EXISTS create_unmanaged_link_trigger ON virtual_topo.unmanaged_links;
CREATE TRIGGER create_unmanaged_link_trigger
    BEFORE INSERT ON virtual_topo.unmanaged_links
    FOR EACH ROW
    EXECUTE PROCEDURE create_corresponding_edge ('unmanaged');
