#!/bin/bash
set -e

PROJECT_GITLAB_PAT="${MY_PROJECT_GITLAB_PAT}"
PROJECT_GITLAB_USER="${MY_PROJECT_GITLAB_USER}"
MY_NETRC=$1

if [ -z $PROJECT_GITLAB_USER ]; then
    echo "MY_PROJECT_GITLAB_USER is not set!"
    exit 1
fi

if [ -z $PROJECT_GITLAB_PAT ]; then
    echo "MY_PROJECT_GITLAB_PAT is not set!"
    exit 1
fi

if [ -z $MY_NETRC ]; then
    echo "Usage: $0 <path_to_netrc_file>"
    exit 1
fi

if [ ! -z $PROJECT_GITLAB_USER ]; then
    if [ ! -z $PROJECT_GITLAB_PAT ]; then
        echo "machine gitlab.com login $PROJECT_GITLAB_USER password $PROJECT_GITLAB_PAT" >$MY_NETRC
        echo "Updating $MY_NETRC ... Done!"
    fi
fi
