/*
	Copyright (C) MOXA Inc. All rights reserved.

	This software is distributed under the terms of the
	MOXA License.  See the file COPYING-MOXA for details.
*/
#pragma once
#include <iostream>
#include <string>
using namespace std;

#ifdef __cplusplus    // If used by C++ code, 
extern "C" {          // we need to export the C interface
#endif

	enum led_mode {
		LED_status_OFF = 0,
		LED_status_ON = 1,
		LED_status_BLINK = 2
	};

	enum LED_STATUS
	{
		LED_ON = 1,
		LED_OFF = 0,
		LIB_INITIALIZE_FAIL = -1,
		PORT_OUTOF_INDEX = -2,
		SET_STATUS_ERR = -3
	};

	HMODULE GetCurrentModule();
	HANDLE mxled_open();
	void mxled_close(HANDLE fd);
	int mxgpio_get_data(HANDLE fd, int port);
	int mxgpio_set_data(HANDLE fd, int port, int data);

	int InitMXLED(void);
	int GetLedCount();
	int GetLedData(int port);
	int SetLedData(int port, int status);
	void SetLedBlink(const WORD &wPortAddr, int led_bit);

#ifdef __cplusplus    // If used by C++ code, 
}
#endif